/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.xml;

import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaderFactory {
    public static final String XERCES_SAXPARSER = "org.apache.xerces.parsers.SAXParser";

    public static XMLReader createXMLReader() throws SAXException {
        Logger logger = LoggerFactory.getLogger(XMLReader.class);
        XMLReader reader = null;
        String xmlReaderName = System.getProperty("org.xml.sax.driver");
        if (xmlReaderName != null) {
            try {
                reader = XMLReaderFactory._createXMLReader(xmlReaderName);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Class " + xmlReaderName + " not found");
            }
            catch (ClassCastException e) {
                logger.warn(xmlReaderName + " is not a valid XMLReader.");
            }
            catch (Exception e) {
                logger.warn("could not create instance of " + xmlReaderName);
            }
            logger.debug("XMLReader initialized using system property: " + xmlReaderName);
        }
        if (reader == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                reader = factory.newSAXParser().getXMLReader();
            }
            catch (NoClassDefFoundError e) {
                logger.warn("javax.xml.parsers.SAXParserFactory not available");
            }
            catch (Exception e) {
                logger.warn("Failed to initialize XMLReader through JAXP");
            }
            logger.debug("XMLReader initialized using JAXP: " + String.valueOf(reader));
        }
        if (reader == null) {
            try {
                reader = XMLReaderFactory._createXMLReader(XERCES_SAXPARSER);
            }
            catch (ClassNotFoundException e) {
                String message = "Class org.apache.xerces.parsers.SAXParser not found";
                logger.error(message);
                throw new SAXException(message);
            }
            catch (ClassCastException e) {
                String message = "org.apache.xerces.parsers.SAXParser is not a valid XMLReader.";
                logger.error(message);
                throw new SAXException(message);
            }
            catch (Exception e) {
                String message = "Could not create instance of org.apache.xerces.parsers.SAXParser";
                logger.error(message);
                throw new SAXException(message);
            }
            logger.debug("XMLReader initialized using default Xerces SAX parser org.apache.xerces.parsers.SAXParser");
        }
        return reader;
    }

    public static XMLReader createXMLReader(String name) throws SAXException {
        XMLReader reader;
        Logger logger = LoggerFactory.getLogger(XMLReader.class);
        try {
            reader = XMLReaderFactory._createXMLReader(name);
        }
        catch (ClassNotFoundException e) {
            logger.error("Class " + name + " not found");
            throw new SAXException(e);
        }
        catch (ClassCastException e) {
            logger.error(name + " is not a valid XMLReader.");
            throw new SAXException(e);
        }
        catch (Exception e) {
            logger.error("Could not create instance of " + name);
            throw new SAXException(e);
        }
        return reader;
    }

    protected static XMLReader _createXMLReader(String name) throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException {
        return (XMLReader)Class.forName(name).newInstance();
    }
}

