/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Iterator;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.xplain.Xplain;

public class XplainPB
extends Xplain<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;

    public XplainPB(IPBSolver solver) {
        super((ISolver)solver);
    }

    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        VecInt coeffs = new VecInt(literals.size(), 1);
        int newvar = this.createNewVar(literals);
        literals.push(newvar);
        coeffs.push(degree);
        IConstr constr = ((IPBSolver)this.decorated()).addAtLeast(literals, (IVecInt)coeffs, degree);
        if (constr == null) {
            this.discardLastestVar();
        } else {
            this.getConstrs().put(newvar, constr);
        }
        return constr;
    }

    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        VecInt coeffs = new VecInt(literals.size(), 1);
        int newvar = this.createNewVar(literals);
        literals.push(newvar);
        coeffs.push(degree - coeffs.size());
        IConstr constr = ((IPBSolver)this.decorated()).addAtMost(literals, (IVecInt)coeffs, degree);
        if (constr == null) {
            this.discardLastestVar();
        } else {
            this.getConstrs().put(newvar, constr);
        }
        return constr;
    }

    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        int newvar = this.createNewVar(literals);
        VecInt coeffs = new VecInt(literals.size(), 1);
        literals.push(newvar);
        coeffs.push(n - coeffs.size());
        IConstr constr1 = ((IPBSolver)this.decorated()).addAtMost(literals, (IVecInt)coeffs, n);
        coeffs.pop();
        coeffs.push(n);
        IConstr constr2 = ((IPBSolver)this.decorated()).addAtLeast(literals, (IVecInt)coeffs, n);
        if (constr1 == null && constr2 == null) {
            this.discardLastestVar();
            return null;
        }
        ConstrGroup group = new ConstrGroup();
        group.add(constr1);
        group.add(constr2);
        this.getConstrs().put(newvar, group);
        return group;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        int newvar = this.createNewVar(lits);
        lits.push(newvar);
        if (moreThan && d.signum() >= 0) {
            coeffs.push((Object)d);
        } else {
            BigInteger sum = BigInteger.ZERO;
            Iterator ite = coeffs.iterator();
            while (ite.hasNext()) {
                sum = sum.add((BigInteger)ite.next());
            }
            sum = sum.subtract(d);
            coeffs.push((Object)sum.negate());
        }
        IConstr constr = ((IPBSolver)this.decorated()).addPseudoBoolean(lits, coeffs, moreThan, d);
        if (constr == null) {
            this.discardLastestVar();
        } else {
            this.getConstrs().put(newvar, constr);
        }
        return constr;
    }

    private IConstr addPseudoBoolean(IVecInt lits, IVecInt coeffs, boolean moreThan, int d) throws ContradictionException {
        IConstr constr;
        int newvar = this.createNewVar(lits);
        lits.push(newvar);
        if (moreThan && d >= 0) {
            coeffs.push(d);
        } else {
            int sum = 0;
            IteratorInt ite = coeffs.iterator();
            while (ite.hasNext()) {
                sum += ite.next();
            }
            coeffs.push(-(sum -= d));
        }
        IConstr iConstr = constr = moreThan ? ((IPBSolver)this.decorated()).addAtLeast(lits, coeffs, d) : ((IPBSolver)this.decorated()).addAtMost(lits, coeffs, d);
        if (constr == null) {
            this.discardLastestVar();
        } else {
            this.getConstrs().put(newvar, constr);
        }
        return constr;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        ((IPBSolver)this.decorated()).setObjectiveFunction(obj);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return ((IPBSolver)this.decorated()).getObjectiveFunction();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        return this.addPseudoBoolean(literals, coeffs, false, degree);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        return this.addPseudoBoolean(literals, coeffs, false, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        return this.addPseudoBoolean(literals, coeffs, true, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        return this.addPseudoBoolean(literals, coeffs, true, degree);
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }
}

