/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.reporting;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.SherlockCore;
import org.eclipse.rcptt.sherlock.core.reporting.IEventProvider;
import org.eclipse.rcptt.sherlock.core.reporting.IReportBuilder;

public class EventProviderManager {
    private Map<String, IEventProvider> managers = null;
    private static EventProviderManager instance = null;

    private EventProviderManager() {
    }

    private synchronized void initialize() {
        IConfigurationElement[] elements;
        if (this.managers != null) {
            return;
        }
        this.managers = new HashMap<String, IEventProvider>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.watson.core.eventProvider");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            try {
                Object id = cfg.getAttribute("id");
                IEventProvider provider = (IEventProvider)cfg.createExecutableExtension("class");
                if (id == null || this.managers.containsKey(id)) {
                    SherlockCore.log("Duplicate or invalid id for event provider:" + provider.getClass().getName() + " id:" + (String)id);
                    id = "" + System.currentTimeMillis();
                }
                this.managers.put((String)id, provider);
            }
            catch (CoreException e) {
                SherlockCore.log(e);
            }
            ++n2;
        }
    }

    public synchronized IEventProvider[] getExtensions() {
        this.initialize();
        return this.managers.values().toArray(new IEventProvider[this.managers.size()]);
    }

    public static synchronized EventProviderManager getInstance() {
        if (instance == null) {
            instance = new EventProviderManager();
        }
        return instance;
    }

    public synchronized void register(IReportBuilder reportBuilder, String id) {
        this.initialize();
        for (Map.Entry<String, IEventProvider> provider : this.managers.entrySet()) {
            if (id != null && !provider.getKey().startsWith(id)) continue;
            provider.getValue().removeListener(reportBuilder);
            provider.getValue().addListener(reportBuilder);
        }
    }

    public synchronized void unregister(IReportBuilder reportBuilder, String id) {
        this.initialize();
        for (Map.Entry<String, IEventProvider> provider : this.managers.entrySet()) {
            if (id != null && !provider.getKey().startsWith(id)) continue;
            provider.getValue().removeListener(reportBuilder);
        }
    }

    public void takeSnapshot(INodeBuilder node) {
        this.initialize();
        for (Map.Entry<String, IEventProvider> provider : this.managers.entrySet()) {
            provider.getValue().storeSnapshot(node);
        }
    }
}

