/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.testrail;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.rcptt.internal.testrail.Messages;
import org.eclipse.rcptt.internal.testrail.TestRailPlugin;
import org.eclipse.rcptt.util.Base64;

public class APIClient {
    private String url;
    private String username;
    private String password;
    private boolean useUnicode;

    public APIClient(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.useUnicode = false;
    }

    public void setUseUnicode(boolean useUnicode) {
        this.useUnicode = useUnicode;
    }

    public String sendGetRequest(String endpoint) {
        HttpGet request = new HttpGet(this.url + endpoint);
        return this.sendRequest((HttpUriRequest)request);
    }

    public String sendPostRequest(String endpoint, String params) {
        HttpPost request = new HttpPost(this.url + endpoint);
        if (this.useUnicode) {
            request.setEntity((HttpEntity)new StringEntity(params, StandardCharsets.UTF_8));
        } else {
            request.setEntity((HttpEntity)new StringEntity(params, StandardCharsets.ISO_8859_1));
        }
        TestRailPlugin.logInfo(MessageFormat.format(Messages.APIClient_GeneratedRequest, params));
        return this.sendRequest((HttpUriRequest)request);
    }

    private String sendRequest(HttpUriRequest request) {
        String entity;
        block3: {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            this.setUpHeaders(request);
            try {
                HttpResponse response = client.execute(request);
                StatusLine status = response.getStatusLine();
                entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() == 200) break block3;
                TestRailPlugin.log(MessageFormat.format(Messages.APIClient_HTTPError, status.getStatusCode(), entity.equals("") ? status.getReasonPhrase() : entity));
                return null;
            }
            catch (Exception e) {
                TestRailPlugin.log(Messages.APIClient_ErrorWhileSendingRequest, e);
                return null;
            }
        }
        TestRailPlugin.logInfo(MessageFormat.format(Messages.APIClient_RecievedResponse, entity));
        return entity;
    }

    private void setUpHeaders(HttpUriRequest request) {
        String credentials = this.username + ":" + this.password;
        String encodedCredentials = Base64.encode((byte[])credentials.getBytes(StandardCharsets.ISO_8859_1));
        String authorizationHeader = "Basic " + new String(encodedCredentials);
        request.setHeader("Authorization", authorizationHeader);
        String contentTypeHeader = "application/json";
        request.addHeader("Content-Type", contentTypeHeader);
    }
}

