/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.CopyProjectChange;
import org.eclipse.ltk.core.refactoring.resource.CopyProjectDescriptor;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public class CopyProjectProcessor
extends CopyProcessor {
    private IProject fProject;
    private String fNewName;
    private IPath fNewLocation;

    public CopyProjectProcessor(IProject project, String newName, IPath newLocation) {
        if (project == null || !project.exists()) {
            throw new IllegalArgumentException("project must not be null and must exist");
        }
        this.fProject = project;
        this.fNewName = newName;
        this.fNewLocation = newLocation;
    }

    public IProject getProjectToCopy() {
        return this.fProject;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean autoRefresh;
        IStatus status = Resources.checkInSync((IResource)this.fProject);
        if (!status.isOK() && (autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null))) {
            this.fProject.refreshLocal(2, pm);
            status = Resources.checkInSync((IResource)this.fProject);
        }
        return RefactoringStatus.create(status);
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            if (!this.isSynchronizedExcludingLinkedResources((IResource)this.fProject)) {
                String pathLabel = BasicElementLabels.getPathLabel(this.fProject.getFullPath(), false);
                String locationLabel = null;
                IPath location = this.fProject.getLocation();
                if (location != null) {
                    locationLabel = BasicElementLabels.getPathLabel(location, true);
                } else {
                    URI uri = this.fProject.getLocationURI();
                    if (uri != null) {
                        locationLabel = BasicElementLabels.getURLPart(uri.toString());
                    }
                }
                String warning = locationLabel != null ? Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_warning_out_of_sync_container_loc, new Object[]{pathLabel, locationLabel}) : Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_warning_out_of_sync_container, pathLabel);
                result.addWarning(warning);
            }
            this.checkDirtyResources(result);
            if (ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNewName).exists()) {
                result.addError(Messages.format(RefactoringCoreMessages.CopyProjectProcessor_error_project_exists, this.fNewName));
            }
            ResourceChangeChecker checker = context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            deltaFactory.copy((IResource)this.fProject, this.fNewLocation.append(this.fNewName));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean isSynchronizedExcludingLinkedResources(IResource resource) throws CoreException {
        boolean[] result = new boolean[]{true};
        resource.accept(visitedResource -> {
            if (!result[0] || visitedResource.isLinked()) {
                return false;
            }
            if (!visitedResource.isSynchronized(0)) {
                blArray[0] = false;
                return false;
            }
            return true;
        }, 2, 16);
        return result[0];
    }

    private void checkDirtyResources(RefactoringStatus result) throws CoreException {
        if (!this.fProject.isOpen()) {
            return;
        }
        this.fProject.accept(visitedResource -> {
            if (visitedResource instanceof IFile) {
                this.checkDirtyFile(result, (IFile)visitedResource);
            }
            return true;
        }, 2, false);
    }

    private void checkDirtyFile(RefactoringStatus result, IFile file) {
        if (!file.exists()) {
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null && buffer.isDirty()) {
            String message = RefactoringCoreMessages.DeleteResourcesProcessor_warning_unsaved_file;
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                result.addWarning(Messages.format(message, BasicElementLabels.getPathLabel(file.getFullPath(), false)));
            } else {
                result.addFatalError(Messages.format(message, BasicElementLabels.getPathLabel(file.getFullPath(), false)));
            }
        }
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(RefactoringCoreMessages.DeleteResourcesProcessor_create_task, 1);
        try {
            CopyProjectChange change = new CopyProjectChange(this.fProject, this.fNewLocation, this.fNewName);
            change.setDescriptor(new RefactoringChangeDescriptor(this.createDescriptor()));
            CopyProjectChange copyProjectChange = change;
            return copyProjectChange;
        }
        finally {
            pm.done();
        }
    }

    protected CopyProjectDescriptor createDescriptor() {
        CopyProjectDescriptor descriptor = new CopyProjectDescriptor();
        descriptor.setProject(null);
        descriptor.setDescription(this.getDescription());
        descriptor.setComment(descriptor.getDescription());
        descriptor.setFlags(7);
        descriptor.setProjectToCopy(this.fProject);
        descriptor.setNewName(this.fNewName);
        descriptor.setNewLocation(this.fNewLocation);
        return descriptor;
    }

    private String getDescription() {
        return Messages.format(RefactoringCoreMessages.CopyProjectProcessor_description, BasicElementLabels.getPathLabel(this.fProject.getFullPath(), false));
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    @Override
    public String getIdentifier() {
        return "org.eclipse.ltk.core.refactoring.copyProjectProcessor";
    }

    @Override
    public String getProcessorName() {
        return RefactoringCoreMessages.CopyProjectProcessor_name;
    }

    @Override
    public boolean isApplicable() throws CoreException {
        if (this.fProject == null) {
            return false;
        }
        if (!this.fProject.exists()) {
            return false;
        }
        return this.fProject.isAccessible();
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures((IResource)this.fProject);
        CopyArguments copyArguments = new CopyArguments(this.fNewLocation.append(this.fNewName), new ReorgExecutionLog());
        return ParticipantManager.loadCopyParticipants(status, this, this.fProject, copyArguments, affectedNatures, sharedParticipants);
    }
}

