/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.wizards;

import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.RepositoryPlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.bnd.ui.Central;
import org.eclipse.pde.bnd.ui.RefreshFileJob;
import org.eclipse.pde.bnd.ui.wizards.AddFilesToRepositoryWizardPage;
import org.eclipse.pde.bnd.ui.wizards.LocalRepositorySelectionPage;

public class AddFilesToRepositoryWizard
extends Wizard {
    private RepositoryPlugin repository;
    private final File[] files;
    private List<Map.Entry<String, String>> selectedBundles;
    private final LocalRepositorySelectionPage repoSelectionPage;
    private final AddFilesToRepositoryWizardPage fileSelectionPage;
    private final Workspace workspace;

    public AddFilesToRepositoryWizard(Workspace workspace, RepositoryPlugin repository, File[] initialFiles) {
        this.workspace = workspace;
        this.repository = repository;
        this.files = initialFiles;
        this.repoSelectionPage = new LocalRepositorySelectionPage(workspace, "repoSelectionPage", repository);
        this.fileSelectionPage = new AddFilesToRepositoryWizardPage("fileSelectionPage");
        this.fileSelectionPage.setFiles(this.files);
    }

    public void addPages() {
        if (this.repository == null) {
            this.addPage((IWizardPage)this.repoSelectionPage);
            this.repoSelectionPage.addPropertyChangeListener("selectedRepository", evt -> {
                RepositoryPlugin repositoryPlugin = this.repository = (RepositoryPlugin)evt.getNewValue();
            });
        }
        this.addPage((IWizardPage)this.fileSelectionPage);
    }

    public boolean performFinish() {
        WorkspaceJob job = new WorkspaceJob("Adding files to repository"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                MultiStatus status = new MultiStatus(AddFilesToRepositoryWizard.class, 0, "Failed to install one or more bundles", null);
                List<File> files = AddFilesToRepositoryWizard.this.fileSelectionPage.getFiles();
                ArrayList<File> refresh = new ArrayList<File>();
                AddFilesToRepositoryWizard.this.selectedBundles = new LinkedList<Map.Entry<String, String>>();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)files.size());
                for (File file : files) {
                    block26: {
                        Object var9_13;
                        try {
                            Throwable throwable = null;
                            var9_13 = null;
                            try (Jar jar = new Jar(file);){
                                String bsn = jar.getBsn();
                                String version = jar.getVersion();
                                AddFilesToRepositoryWizard.this.selectedBundles.add(Map.entry(bsn, version != null ? version : "0"));
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            status.add(Status.error((String)MessageFormat.format("Failed to analyze JAR: {0}", file.getPath()), (Throwable)e));
                            progress.worked(1);
                            continue;
                        }
                        try {
                            Throwable e = null;
                            var9_13 = null;
                            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                                RepositoryPlugin.PutResult result = AddFilesToRepositoryWizard.this.repository.put((InputStream)in, new RepositoryPlugin.PutOptions());
                                URI artifact = result.artifact;
                                if (artifact != null && artifact.getScheme().equalsIgnoreCase("file")) {
                                    refresh.add(new File(artifact));
                                }
                                if (!(AddFilesToRepositoryWizard.this.repository instanceof Refreshable)) break block26;
                                Central.refreshPlugin(AddFilesToRepositoryWizard.this.workspace, (Refreshable)AddFilesToRepositoryWizard.this.repository, true);
                            }
                            catch (Throwable throwable) {
                                if (e == null) {
                                    e = throwable;
                                } else if (e != throwable) {
                                    e.addSuppressed(throwable);
                                }
                                throw e;
                            }
                        }
                        catch (Exception e) {
                            status.add(Status.error((String)MessageFormat.format("Failed to add JAR to repository: {0}", file.getPath()), (Throwable)e));
                            progress.worked(1);
                            continue;
                        }
                    }
                    progress.worked(1);
                }
                RefreshFileJob refreshJob = new RefreshFileJob(refresh, false);
                if (refreshJob.needsToSchedule()) {
                    refreshJob.schedule();
                }
                progress.done();
                return status;
            }
        };
        job.schedule();
        return true;
    }

    public List<Map.Entry<String, String>> getSelectedBundles() {
        return Collections.unmodifiableList(this.selectedBundles);
    }
}

