/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.internal.core.TeamPlugin;

public final class TeamResourceChangeListener
implements IResourceChangeListener {
    private static final Map<String, IPath[]> metaFilePaths;

    static {
        String[] ids;
        metaFilePaths = new HashMap<String, IPath[]>();
        String[] stringArray = ids = RepositoryProvider.getAllProviderTypeIds();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IPath[] paths = TeamPlugin.getMetaFilePaths(id);
            if (paths != null) {
                metaFilePaths.put(id, paths);
            }
            ++n2;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        IResourceDelta[] iResourceDeltaArray = projectDeltas = event.getDelta().getAffectedChildren();
        int n = projectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryProvider provider;
            IResourceDelta delta = iResourceDeltaArray[n2];
            IResource resource = delta.getResource();
            IProject project = resource.getProject();
            if (!RepositoryProvider.isShared(project)) {
                this.handleUnsharedProjectChanges(project, delta);
            } else if (delta.getKind() == 1 && (delta.getFlags() & 0x1000) != 0 && (provider = RepositoryProvider.getProvider(project)) != null && !provider.getProject().equals((Object)project)) {
                provider.setProject(project);
            }
            ++n2;
        }
    }

    private void handleUnsharedProjectChanges(IProject project, IResourceDelta delta) {
        IFile[] files;
        String repositoryId = null;
        HashSet<IContainer> metaFileContainers = new HashSet<IContainer>();
        HashSet<String> badIds = new HashSet<String>();
        IFile[] iFileArray = files = this.getAddedFiles(delta);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            String typeId = this.getMetaFileType(file);
            if (typeId != null) {
                if (repositoryId == null) {
                    repositoryId = typeId;
                } else if (!repositoryId.equals(typeId) && !badIds.contains(typeId)) {
                    TeamPlugin.log(2, "Meta files for two repository types (" + repositoryId + " and " + typeId + " was found in project " + project.getName() + ".", null);
                    badIds.add(typeId);
                }
                if (typeId.equals(repositoryId)) {
                    IContainer container = this.getContainer(typeId, file);
                    metaFileContainers.add(container);
                }
            }
            ++n2;
        }
        if (repositoryId != null) {
            RepositoryProviderType type = RepositoryProviderType.getProviderType(repositoryId);
            type.metaFilesDetected(project, metaFileContainers.toArray(new IContainer[metaFileContainers.size()]));
        }
    }

    private IContainer getContainer(String typeId, IFile file) {
        IPath[] paths = metaFilePaths.get(typeId);
        IPath foundPath = null;
        IPath projectRelativePath = file.getProjectRelativePath();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (this.isSuffix(projectRelativePath, path)) {
                foundPath = path;
            }
            ++n2;
        }
        IFile resource = file;
        if (foundPath != null) {
            int i = 0;
            while (i < foundPath.segmentCount()) {
                resource = resource.getParent();
                ++i;
            }
        }
        if (resource.getType() == 1) {
            return file.getParent();
        }
        return (IContainer)resource;
    }

    private String getMetaFileType(IFile file) {
        for (String id : metaFilePaths.keySet()) {
            IPath[] paths;
            IPath[] iPathArray = paths = metaFilePaths.get(id);
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                if (this.isSuffix(file.getProjectRelativePath(), path)) {
                    return id;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isSuffix(IPath path, IPath suffix) {
        if (path.segmentCount() < suffix.segmentCount()) {
            return false;
        }
        int i = 0;
        while (i < suffix.segmentCount()) {
            if (!suffix.segment(i).equals(path.segment(path.segmentCount() - suffix.segmentCount() + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IFile[] getAddedFiles(IResourceDelta delta) {
        ArrayList result = new ArrayList();
        try {
            delta.accept(delta1 -> {
                if ((delta1.getKind() & 1) != 0 && delta1.getResource().getType() == 1) {
                    result.add((IFile)delta1.getResource());
                }
                return true;
            });
        }
        catch (CoreException e) {
            TeamPlugin.log(4, "An error occurred while scanning for meta-file changes", e);
        }
        return result.toArray(new IFile[result.size()]);
    }
}

