/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.launching.rap.IBrowserLaunchDelegate;
import org.eclipse.rcptt.launching.rap.RAPLaunchConfig;
import org.eclipse.swt.program.Program;

public class RunnerBrowserLaunchDelegate
implements IBrowserLaunchDelegate {
    private static final String HTML_EXTENSION = "html";

    public void launch(URL uri, RAPLaunchConfig config) throws CoreException {
        if (RunnerBrowserLaunchDelegate.hasDefaultBrowser(config)) {
            this.openDefaultSystemBrowser(uri);
        } else {
            this.openCustomBrowserCommand(uri, config.getBrowserCommand());
        }
    }

    private void openCustomBrowserCommand(URL uri, String command) throws CoreException {
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(String.format(command, uri.toString()));
        }
        catch (IOException iOException) {
            RunnerBrowserLaunchDelegate.throwsOpenURLFailed(uri);
        }
    }

    private void openDefaultSystemBrowser(URL uri) throws CoreException {
        Program program = Program.findProgram((String)HTML_EXTENSION);
        if (program != null && program.execute(uri.toString())) {
            return;
        }
        if (!Program.launch((String)uri.toString())) {
            RunnerBrowserLaunchDelegate.throwsOpenURLFailed(uri);
        }
    }

    private static void throwsOpenURLFailed(URL uri) throws CoreException {
        String message = String.format("Failed to open URL '%s' in browser.", uri);
        Status fail = new Status(4, "org.eclipse.rcptt.runner", message);
        throw new CoreException((IStatus)fail);
    }

    private static boolean hasDefaultBrowser(RAPLaunchConfig config) throws CoreException {
        return config.getBrowserCommand() == null;
    }
}

