/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import org.eclipse.rcptt.tesla.core.protocol.PartUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SetStatusDialogMode;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.recording.aspects.ActionType;
import org.eclipse.rcptt.tesla.recording.aspects.IWorkbenchEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.WorkbenchEventManager;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class WorkbenchRecordingProcessor
implements IRecordingProcessor,
IWorkbenchEventListener {
    private TeslaRecorder recorder;

    public WorkbenchRecordingProcessor() {
        WorkbenchEventManager.addListener((IWorkbenchEventListener)this);
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
                WorkbenchRecordingProcessor.this.restartEclipse();
            }
        });
    }

    public void closeEditors(IEditorReference[] refArray) {
        Shell[] shells;
        Display display = PlatformUI.getWorkbench().getDisplay();
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (SWTEventRecorder.isModal(shell)) {
                return;
            }
            ++n2;
        }
        if (!this.getSWTProcessor().getRecorder().hasListeners()) {
            return;
        }
        shellArray = refArray;
        n = refArray.length;
        n2 = 0;
        while (n2 < n) {
            Shell ref = shellArray[n2];
            PartUIElement resultPart = this.getSWTProcessor().getLocator().findPartElement(ref.getPart(false), false);
            if (resultPart != null) {
                resultPart.close();
            }
            ++n2;
        }
    }

    private SWTEventRecorder getSWTProcessor() {
        return (SWTEventRecorder)this.recorder.getProcessor(SWTEventRecorder.class);
    }

    public void restartEclipse() {
        this.getSWTProcessor().getRecorder().safeExecuteCommand((Command)ProtocolFactory.eINSTANCE.createWaitForRestart());
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        this.recorder = teslaRecorder;
    }

    public int getInitLevel() {
        return 1000;
    }

    public void clear() {
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    public void recordAction(ActionType type) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.recorder.safeExecuteCommand(this.commandByAction(type));
    }

    private Command commandByAction(ActionType type) {
        switch (type) {
            case ABOUT_DIALOG: {
                return ProtocolFactory.eINSTANCE.createClickAboutMenu();
            }
            case PREFERENCE_DIALOG: {
                return ProtocolFactory.eINSTANCE.createClickPreferencesMenu();
            }
        }
        throw new IllegalArgumentException("Couldn't find command for action: " + type);
    }

    public void recordAddStatus(StatusAdapter adapter, boolean modal) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        SetStatusDialogMode mode = ProtocolFactory.eINSTANCE.createSetStatusDialogMode();
        mode.setEnabled(true);
        this.recorder.executeCommand((Command)mode);
    }

    public void recordStatusCleanup() {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        SetStatusDialogMode mode = ProtocolFactory.eINSTANCE.createSetStatusDialogMode();
        mode.setEnabled(false);
        this.recorder.executeCommand((Command)mode);
    }

    public void resetAssertSelection() {
    }

    public IRecordingHelper<?> getHelper() {
        return null;
    }
}

