/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Optional;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;
import org.junit.vintage.engine.discovery.UniqueIdFilter;

class UniqueIdSelectorResolver
implements DiscoverySelectorResolver {
    private static final Logger logger = LoggerFactory.getLogger(UniqueIdSelectorResolver.class);

    UniqueIdSelectorResolver() {
    }

    @Override
    public void resolve(EngineDiscoveryRequest request, ClassFilter classFilter, TestClassCollector collector) {
        request.getSelectorsByType(UniqueIdSelector.class).stream().map(UniqueIdSelector::getUniqueId).filter(this::isNotEngineId).filter(this::isForVintageEngine).forEach(uniqueId -> this.resolveIntoFilteredTestClass((UniqueId)uniqueId, classFilter, collector));
    }

    private boolean isNotEngineId(UniqueId uniqueId) {
        boolean isEngineId = UniqueId.forEngine((String)"junit-vintage").equals((Object)uniqueId);
        if (isEngineId) {
            logger.warn(() -> String.format("Unresolvable Unique ID (%s): Cannot resolve the engine's unique ID", uniqueId));
        }
        return !isEngineId;
    }

    private boolean isForVintageEngine(UniqueId uniqueId) {
        return uniqueId.getEngineId().map(engineId -> engineId.equals("junit-vintage")).orElse(false);
    }

    private void resolveIntoFilteredTestClass(UniqueId uniqueId, ClassFilter classFilter, TestClassCollector collector) {
        this.determineTestClassName(uniqueId).flatMap(testClassName -> this.loadTestClass((String)testClassName, uniqueId)).filter(classFilter).ifPresent(testClass -> collector.addFiltered((Class<?>)testClass, new UniqueIdFilter(uniqueId)));
    }

    private Optional<Class<?>> loadTestClass(String className, UniqueId uniqueId) {
        return ReflectionUtils.tryToLoadClass((String)className).ifFailure(cause -> logger.warn((Throwable)cause, () -> String.format("Unresolvable Unique ID (%s): Unknown class %s", uniqueId, className))).toOptional();
    }

    private Optional<String> determineTestClassName(UniqueId uniqueId) {
        UniqueId.Segment runnerSegment = (UniqueId.Segment)uniqueId.getSegments().get(1);
        if ("runner".equals(runnerSegment.getType())) {
            return Optional.of(runnerSegment.getValue());
        }
        logger.warn(() -> String.format("Unresolvable Unique ID (%s): Unique ID segment after engine segment must be of type \"runner\"", uniqueId));
        return Optional.empty();
    }
}

