/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.client.auth.pubkey.KeyPairIdentity;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;

public class JGitPublicKeyIterator
extends AbstractKeyPairIterator<PublicKeyIdentity>
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private SshAgent agent;
    private final List<Iterator<PublicKeyIdentity>> keys = new ArrayList<Iterator<PublicKeyIdentity>>(3);
    private final Iterator<Iterator<PublicKeyIdentity>> keyIter;
    private Iterator<PublicKeyIdentity> current;
    private Boolean hasElement;

    public JGitPublicKeyIterator(ClientSession session, SignatureFactoriesManager signatureFactories) throws Exception {
        super(session);
        boolean useAgent = true;
        if (session instanceof JGitClientSession) {
            HostConfigEntry config = ((JGitClientSession)session).getHostConfigEntry();
            boolean bl = useAgent = !config.isIdentitiesOnly();
        }
        if (useAgent) {
            SshAgentFactory factory;
            ClientFactoryManager manager = session.getFactoryManager();
            SshAgentFactory sshAgentFactory = factory = manager == null ? null : manager.getAgentFactory();
            if (factory != null) {
                try {
                    this.agent = factory.createClient((FactoryManager)manager);
                    this.keys.add(new AgentIdentityIterator(this.agent));
                }
                catch (IOException e) {
                    try {
                        this.closeAgent();
                    }
                    catch (IOException err) {
                        e.addSuppressed(err);
                    }
                    throw e;
                }
            }
        }
        this.keys.add(new KeyPairIdentityIterator((KeyIdentityProvider)session.getRegisteredIdentities(), session, signatureFactories));
        this.keys.add(new KeyPairIdentityIterator((KeyIdentityProvider)session.getKeyPairProvider(), session, signatureFactories));
        this.keyIter = this.keys.iterator();
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.closeAgent();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasNext() {
        if (!this.isOpen()) {
            return false;
        }
        if (this.hasElement == null) ** GOTO lbl11
        return this.hasElement;
lbl-1000:
        // 1 sources

        {
            if (this.keyIter.hasNext()) {
                this.current = this.keyIter.next();
                continue;
            }
            this.current = null;
            this.hasElement = Boolean.FALSE;
            return false;
lbl11:
            // 2 sources

            ** while (this.current == null || !this.current.hasNext())
        }
lbl12:
        // 1 sources

        this.hasElement = Boolean.TRUE;
        return true;
    }

    public PublicKeyIdentity next() {
        PublicKeyIdentity result;
        if (!this.isOpen() || this.hasElement == null && !this.hasNext() || !this.hasElement.booleanValue()) {
            throw new NoSuchElementException();
        }
        this.hasElement = null;
        try {
            result = this.current.next();
        }
        catch (NoSuchElementException e) {
            result = null;
        }
        return result;
    }

    private void closeAgent() throws IOException {
        if (this.agent == null) {
            return;
        }
        try {
            this.agent.close();
        }
        finally {
            this.agent = null;
        }
    }

    private static class AgentIdentityIterator
    implements Iterator<PublicKeyIdentity> {
        private final SshAgent agent;
        private final Iterator<? extends Map.Entry<PublicKey, String>> iter;

        public AgentIdentityIterator(SshAgent agent) throws IOException {
            this.agent = agent;
            this.iter = agent == null ? null : agent.getIdentities().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter != null && this.iter.hasNext();
        }

        @Override
        public PublicKeyIdentity next() {
            if (this.iter == null) {
                throw new NoSuchElementException();
            }
            Map.Entry<PublicKey, String> entry = this.iter.next();
            return new KeyAgentIdentity(this.agent, entry.getKey(), entry.getValue());
        }
    }

    private static class KeyPairIdentityIterator
    implements Iterator<PublicKeyIdentity> {
        private final Iterator<KeyPair> keyPairs;
        private final ClientSession session;
        private final SignatureFactoriesManager signatureFactories;

        public KeyPairIdentityIterator(KeyIdentityProvider provider, ClientSession session, SignatureFactoriesManager signatureFactories) {
            this.session = session;
            this.signatureFactories = signatureFactories;
            this.keyPairs = provider == null ? null : provider.loadKeys().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keyPairs != null && this.keyPairs.hasNext();
        }

        @Override
        public PublicKeyIdentity next() {
            if (this.keyPairs == null) {
                throw new NoSuchElementException();
            }
            KeyPair key = this.keyPairs.next();
            return new KeyPairIdentity(this.signatureFactories, (SignatureFactoriesManager)this.session, key);
        }
    }
}

