/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.CollapseAllLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.CreateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.CreateLaunchConfigurationPrototypeAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeleteLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DuplicateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.ExportLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.FilterLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationFilteredTree;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LinkPrototypeAction;
import org.eclipse.debug.internal.ui.launchConfigurations.ResetWithPrototypeValuesAction;
import org.eclipse.debug.internal.ui.launchConfigurations.UnlinkPrototypeAction;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;

public class LaunchConfigurationView
extends AbstractDebugView
implements ILaunchConfigurationListener {
    private LaunchConfigurationFilteredTree fTree;
    private ILaunchManager fLaunchManager = DebugPlugin.getDefault().getLaunchManager();
    private LaunchGroupExtension fLaunchGroup;
    private CreateLaunchConfigurationAction fCreateAction;
    private CreateLaunchConfigurationPrototypeAction fCreatePrototypeAction;
    private DeleteLaunchConfigurationAction fDeleteAction;
    private DuplicateLaunchConfigurationAction fDuplicateAction;
    private ExportLaunchConfigurationAction fExportAction;
    private CollapseAllLaunchConfigurationAction fCollapseAllAction;
    private LinkPrototypeAction fLinkPrototypeAction;
    private UnlinkPrototypeAction fUnlinkPrototypeAction;
    private ResetWithPrototypeValuesAction fResetWithPrototypeValuesAction;
    private FilterLaunchConfigurationAction fFilterAction;
    private Label fFilteredNotice = null;
    private boolean fAutoSelect = true;
    private ViewerFilter[] fFilters = null;

    public LaunchConfigurationView(LaunchGroupExtension launchGroup) {
        this.fLaunchGroup = launchGroup;
    }

    public LaunchConfigurationView(LaunchGroupExtension launchGroup, ViewerFilter[] filters) {
        this.fLaunchGroup = launchGroup;
        this.fFilters = filters;
    }

    protected LaunchGroupExtension getLaunchGroup() {
        return this.fLaunchGroup;
    }

    @Override
    protected Viewer createViewer(Composite parent) {
        this.fTree = new LaunchConfigurationFilteredTree(parent, 770, new PatternFilter(), this.fLaunchGroup, this.fFilters);
        this.fTree.createViewControl();
        this.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        LaunchConfigurationViewer viewer = this.fTree.getLaunchConfigurationViewer();
        viewer.setLaunchConfigurationView(this);
        return viewer;
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == IContextProvider.class) {
            return (T)new IContextProvider(){

                public int getContextChangeMask() {
                    return 1;
                }

                public IContext getContext(Object target) {
                    String id = LaunchConfigurationView.this.fTree.computeContextId();
                    if (id != null) {
                        return HelpSystem.getContext((String)id);
                    }
                    return null;
                }

                public String getSearchExpression(Object target) {
                    return null;
                }
            };
        }
        return super.getAdapter(key);
    }

    public Text getFilteringTextControl() {
        return this.fTree.getFilterControl();
    }

    @Override
    protected void createActions() {
        this.fCreateAction = new CreateLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(CreateLaunchConfigurationAction.ID_CREATE_ACTION, (IAction)this.fCreateAction);
        this.fCreatePrototypeAction = new CreateLaunchConfigurationPrototypeAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(CreateLaunchConfigurationPrototypeAction.ID_CREATE_PROTOTYPE_ACTION, (IAction)this.fCreatePrototypeAction);
        this.fDeleteAction = new DeleteLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(DeleteLaunchConfigurationAction.ID_DELETE_ACTION, (IAction)this.fDeleteAction);
        this.setAction("Remove_ActionId", (IAction)this.fDeleteAction);
        this.fDuplicateAction = new DuplicateLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(DuplicateLaunchConfigurationAction.ID_DUPLICATE_ACTION, (IAction)this.fDuplicateAction);
        this.fExportAction = new ExportLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(ExportLaunchConfigurationAction.ID_EXPORT_ACTION, (IAction)this.fExportAction);
        this.fCollapseAllAction = new CollapseAllLaunchConfigurationAction((TreeViewer)this.getViewer());
        this.setAction(CollapseAllLaunchConfigurationAction.ID_COLLAPSEALL_ACTION, (IAction)this.fCollapseAllAction);
        this.fFilterAction = new FilterLaunchConfigurationAction();
        this.setAction(FilterLaunchConfigurationAction.ID_FILTER_ACTION, (IAction)this.fFilterAction);
        this.fLinkPrototypeAction = new LinkPrototypeAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(LinkPrototypeAction.ID_LINK_PROTOTYPE_ACTION, (IAction)this.fLinkPrototypeAction);
        this.fUnlinkPrototypeAction = new UnlinkPrototypeAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(UnlinkPrototypeAction.ID_UNLINK_PROTOTYPE_ACTION, (IAction)this.fUnlinkPrototypeAction);
        this.fResetWithPrototypeValuesAction = new ResetWithPrototypeValuesAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(ResetWithPrototypeValuesAction.ID_RESET_WITH_PROTOTYPE_VALUES_ACTION, (IAction)this.fResetWithPrototypeValuesAction);
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.launch_configuration_view_context";
    }

    @Override
    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.fCreateAction);
        menu.add((IAction)this.fCreatePrototypeAction);
        menu.add((IAction)this.fExportAction);
        menu.add((IAction)this.fDuplicateAction);
        menu.add((IAction)this.fDeleteAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fLinkPrototypeAction);
        menu.add((IAction)this.fUnlinkPrototypeAction);
        menu.add((IAction)this.fResetWithPrototypeValuesAction);
    }

    @Override
    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected TreeViewer getTreeViewer() {
        return this.fTree.getLaunchConfigurationViewer();
    }

    @Override
    public void dispose() {
        this.fCreateAction.dispose();
        this.fCreatePrototypeAction.dispose();
        this.fDeleteAction.dispose();
        this.fDuplicateAction.dispose();
        this.fExportAction.dispose();
        this.fFilterAction = null;
        this.fCollapseAllAction = null;
        this.fLinkPrototypeAction.dispose();
        this.fUnlinkPrototypeAction.dispose();
        this.fResetWithPrototypeValuesAction.dispose();
        this.getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        if (this.isSupportedConfiguration(configuration)) {
            ILaunchConfiguration from = this.getLaunchManager().getMovedFrom(configuration);
            Display display = DebugUIPlugin.getStandardDisplay();
            display.asyncExec(() -> {
                if (!this.fTree.isDisposed()) {
                    this.handleConfigurationAdded(configuration, from);
                }
            });
        }
    }

    private void handleConfigurationAdded(ILaunchConfiguration configuration, ILaunchConfiguration from) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            try {
                try {
                    viewer.getControl().setRedraw(false);
                    if (configuration.getPrototype() != null) {
                        viewer.add((Object)configuration.getPrototype(), (Object)configuration);
                    } else {
                        viewer.add((Object)configuration.getType(), (Object)configuration);
                    }
                    if (from != null) {
                        viewer.remove((Object)from);
                    }
                    if (this.isAutoSelect()) {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)configuration), true);
                    }
                    this.updateFilterLabel();
                }
                catch (CoreException coreException) {
                    viewer.getControl().setRedraw(true);
                }
            }
            finally {
                viewer.getControl().setRedraw(true);
            }
        }
    }

    protected boolean isSupportedConfiguration(ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationType type = configuration.getType();
            return !configuration.getAttribute("org.eclipse.debug.ui.private", false) && type.supportsMode(this.getLaunchGroup().getMode()) && this.equalCategories(type.getCategory(), this.getLaunchGroup().getCategory());
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
            return false;
        }
    }

    private boolean equalCategories(String c1, String c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return c1.equals(c2);
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        ILaunchConfiguration to = this.getLaunchManager().getMovedTo(configuration);
        if (to != null) {
            return;
        }
        Display display = DebugUIPlugin.getStandardDisplay();
        display.asyncExec(() -> {
            if (!this.fTree.isDisposed()) {
                this.handleConfigurationRemoved(configuration);
            }
        });
    }

    private void handleConfigurationRemoved(ILaunchConfiguration configuration) {
        this.getTreeViewer().remove((Object)configuration);
        this.updateFilterLabel();
    }

    public void createLaunchDialogControl(Composite parent) {
        this.createViewer(parent);
        this.createActions();
        this.createContextMenu(this.getViewer().getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        this.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LaunchConfigurationView.this.handleKeyPressed(e);
            }
        });
        if (this.getViewer() instanceof StructuredViewer) {
            ((StructuredViewer)this.getViewer()).addDoubleClickListener((IDoubleClickListener)this);
        }
        this.fFilteredNotice = SWTFactory.createLabel(parent, "", 1);
        this.fFilteredNotice.setBackground(parent.getBackground());
    }

    @Override
    public Viewer getViewer() {
        return this.fTree.getLaunchConfigurationViewer();
    }

    public void updateFilterLabel() {
        LaunchConfigurationViewer viewer = (LaunchConfigurationViewer)this.getViewer();
        this.fFilteredNotice.setText(MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationView_0, (Object[])new Object[]{Integer.toString(viewer.getNonFilteredChildCount()), Integer.toString(viewer.getTotalChildCount())}));
    }

    protected ILaunchManager getLaunchManager() {
        return this.fLaunchManager;
    }

    public void setAutoSelect(boolean select) {
        this.fAutoSelect = select;
    }

    protected boolean isAutoSelect() {
        return this.fAutoSelect;
    }
}

