/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.blame;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.ui.internal.blame.AuthorColors;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.swt.graphics.RGB;

public class BlameRevision
extends Revision {
    private int start;
    private int lines = 1;
    private RevCommit commit;
    private Repository repository;
    private String sourcePath;
    private Map<Integer, Integer> sourceLines = new HashMap<Integer, Integer>();
    private Map<RevCommit, Diff> diffToParentCommit = new HashMap<RevCommit, Diff>();

    public Object getHoverInfo() {
        return this;
    }

    public RGB getColor() {
        return AuthorColors.getDefault().getCommitterRGB(this.getAuthor());
    }

    public String getId() {
        return this.commit.abbreviate(7).name();
    }

    public Date getDate() {
        PersonIdent person = this.commit.getAuthorIdent();
        if (person == null) {
            person = this.commit.getCommitterIdent();
        }
        return person != null ? person.getWhen() : new Date(0L);
    }

    public BlameRevision register() {
        this.addRange((ILineRange)new LineRange(this.start, this.lines));
        return this;
    }

    public BlameRevision addLine() {
        ++this.lines;
        return this;
    }

    public BlameRevision reset(int number) {
        this.start = number;
        this.lines = 1;
        return this;
    }

    public BlameRevision setCommit(RevCommit commit) {
        this.commit = commit;
        return this;
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public BlameRevision setRepository(Repository repository) {
        this.repository = repository;
        return this;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getAuthor() {
        return this.commit.getAuthorIdent().getName();
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public Integer getSourceLine(int currentLine) {
        return this.sourceLines.get(currentLine);
    }

    public void addSourceLine(int currentLine, int sourceLine) {
        this.sourceLines.put(currentLine, sourceLine);
    }

    public Diff getDiffToParent(RevCommit parentCommit) {
        if (this.diffToParentCommit.containsKey(parentCommit)) {
            return this.diffToParentCommit.get(parentCommit);
        }
        Diff diff = this.calculateDiffToParent(parentCommit);
        this.diffToParentCommit.put(parentCommit, diff);
        return diff;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Diff calculateDiffToParent(RevCommit parentCommit) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectReader reader = this.repository.newObjectReader();){
                DiffEntry diffEntry = CompareCoreUtils.getChangeDiffEntry((Repository)this.repository, (String)this.sourcePath, (RevCommit)this.commit, (RevCommit)parentCommit, (ObjectReader)reader);
                if (diffEntry == null) {
                    return null;
                }
                RawText oldText = BlameRevision.readText(this.repository, diffEntry.getOldId(), reader, diffEntry.getOldPath());
                RawText newText = BlameRevision.readText(this.repository, diffEntry.getNewId(), reader, diffEntry.getNewPath());
                StoredConfig config = this.repository.getConfig();
                DiffAlgorithm diffAlgorithm = DiffAlgorithm.getAlgorithm((DiffAlgorithm.SupportedAlgorithm)((DiffAlgorithm.SupportedAlgorithm)config.getEnum("diff", null, "algorithm", (Enum)DiffAlgorithm.SupportedAlgorithm.HISTOGRAM)));
                EditList editList = diffAlgorithm.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)oldText, (Sequence)newText);
                return new Diff(diffEntry.getOldPath(), oldText, newText, editList);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static RawText readText(Repository db, AbbreviatedObjectId blobId, ObjectReader reader, String path) throws IOException {
        ObjectLoader oldLoader = LfsFactory.getInstance().applySmudgeFilter(db, reader.open((AnyObjectId)blobId.toObjectId(), 3), LfsFactory.getAttributesForPath((Repository)db, (String)path).get("diff"));
        return new RawText(oldLoader.getCachedBytes());
    }

    public static class Diff {
        private final String oldPath;
        private final RawText oldText;
        private final RawText newText;
        private final EditList editList;

        private Diff(String oldPath, RawText oldText, RawText newText, EditList editList) {
            this.oldPath = oldPath;
            this.oldText = oldText;
            this.newText = newText;
            this.editList = editList;
        }

        public String getOldPath() {
            return this.oldPath;
        }

        public RawText getOldText() {
            return this.oldText;
        }

        public RawText getNewText() {
            return this.newText;
        }

        public EditList getEditList() {
            return this.editList;
        }
    }
}

