/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditorInputFactory;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class CommitEditorInput
extends PlatformObject
implements IEditorInput,
IPersistableElement {
    private RepositoryCommit commit;

    public CommitEditorInput(RepositoryCommit commit) {
        Assert.isNotNull((Object)((Object)commit), (String)"Repository commit cannot be null");
        this.commit = commit;
    }

    public int hashCode() {
        return this.commit.getRevCommit().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CommitEditorInput) {
            RepositoryCommit inputCommit = ((CommitEditorInput)((Object)obj)).commit;
            return this.commit.getRevCommit().equals((AnyObjectId)inputCommit.getRevCommit()) && this.commit.getRepository().equals(inputCommit.getRepository());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (RepositoryCommit.class == adapter) {
            return this.commit;
        }
        if (RevCommit.class == adapter) {
            return this.commit.getRevCommit();
        }
        if (Repository.class == adapter) {
            return this.commit.getRepository();
        }
        return super.getAdapter(adapter);
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return UIIcons.CHANGESET;
    }

    public String getName() {
        return MessageFormat.format(UIText.CommitEditorInput_Name, this.commit.abbreviate(), this.commit.getRepositoryName());
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return MessageFormat.format(UIText.CommitEditorInput_ToolTip, this.commit.getRevCommit().getShortMessage(), this.commit.getRepositoryName());
    }

    public RepositoryCommit getCommit() {
        return this.commit;
    }

    public void saveState(IMemento memento) {
        CommitEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.eclipse.egit.ui.internal.commit.CommitEditorInputFactory";
    }
}

