/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class PreferenceElement
extends QuickAccessElement {
    private static final String separator = " - ";
    private IPreferenceNode preferenceNode;
    private String prefix;
    private String matchLabelCache;

    PreferenceElement(IPreferenceNode preferenceNode, String prefix, PreferenceProvider preferenceProvider) {
        super(preferenceProvider);
        this.preferenceNode = preferenceNode;
        this.prefix = prefix;
    }

    @Override
    public void execute() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            WorkbenchPreferenceDialog dialog = WorkbenchPreferenceDialog.createDialogOn(window.getShell(), this.preferenceNode.getId());
            dialog.open();
        }
    }

    @Override
    public String getId() {
        return this.preferenceNode.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Image image = this.preferenceNode.getLabelImage();
        if (image != null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)image);
            return descriptor;
        }
        return null;
    }

    @Override
    public String getLabel() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return String.valueOf(this.preferenceNode.getLabelText()) + separator + this.prefix;
        }
        return this.preferenceNode.getLabelText();
    }

    @Override
    public String getMatchLabel() {
        if (this.matchLabelCache == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(super.getSortLabel());
            if (this.preferenceNode instanceof WorkbenchPreferenceExtensionNode) {
                ((WorkbenchPreferenceExtensionNode)this.preferenceNode).getKeywordLabels().forEach(label -> {
                    builder.append(separator);
                    builder.append((String)label);
                });
            }
            this.matchLabelCache = builder.toString();
        }
        return this.matchLabelCache;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.preferenceNode == null ? 0 : this.preferenceNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreferenceElement other = (PreferenceElement)obj;
        return !(this.preferenceNode == null ? other.preferenceNode != null : !this.preferenceNode.equals(other.preferenceNode));
    }
}

