/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.launchconfigurations;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.importexport.launchconfigurations.WizardMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;

public class ImportLaunchConfigurationsWizardPage
extends WizardResourceImportPage {
    private String OVERWRITE = "import_config_overwrite";
    private String OLD_PATH = "import_config_oldpath";
    private Text fFromDirectory = null;
    private Button fOverwrite = null;

    public ImportLaunchConfigurationsWizardPage() {
        super(WizardMessages.ImportLaunchConfigurationsWizardPage_0, (IStructuredSelection)new StructuredSelection());
        this.setTitle(WizardMessages.ImportLaunchConfigurationsWizardPage_0);
        this.setMessage(WizardMessages.ImportLaunchConfigurationsWizardPage_5);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.createRootDirectoryGroup(comp);
        this.createFileSelectionGroup(comp);
        IDialogSettings settings = this.getDialogSettings();
        this.fOverwrite = SWTFactory.createCheckButton(comp, WizardMessages.ImportLaunchConfigurationsWizardPage_1, null, settings.getBoolean(this.OVERWRITE), 1);
        String oldpath = settings.get(this.OLD_PATH);
        oldpath = oldpath == null ? "" : oldpath;
        this.fFromDirectory.setText(oldpath == null ? "" : oldpath);
        this.resetSelection((IPath)new Path(oldpath));
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.debug.ui.import_launch_configurations_context");
        this.setPageComplete(false);
    }

    public boolean finish() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(this.OVERWRITE, this.fOverwrite.getSelection());
        settings.put(this.OLD_PATH, this.fFromDirectory.getText().trim());
        boolean overwrite = this.fOverwrite.getSelection();
        List items = this.getSelectedResources();
        File newconfig = null;
        boolean owall = false;
        boolean nowall = false;
        MessageDialog dialog = null;
        final ArrayList<File> filesToImport = new ArrayList<File>();
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            File config = (File)((DebugFileSystemElement)((Object)iter.next())).getFileSystemObject();
            newconfig = new File(new Path(LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH.toOSString()).append(config.getName()).toOSString());
            if (newconfig.exists() & !overwrite) {
                if (nowall) continue;
                if (!owall) {
                    dialog = new MessageDialog(DebugUIPlugin.getShell(), WizardMessages.ExportLaunchConfigurationsWizardPage_11, null, MessageFormat.format((String)WizardMessages.ExportLaunchConfigurationsWizardPage_12, (Object[])new Object[]{config.getName()}), 3, new String[]{WizardMessages.ExportLaunchConfigurationsWizardPage_13, WizardMessages.ExportLaunchConfigurationsWizardPage_14, WizardMessages.ExportLaunchConfigurationsWizardPage_15, WizardMessages.ExportLaunchConfigurationsWizardPage_16, WizardMessages.ExportLaunchConfigurationsWizardPage_17}, 0);
                    int ret = dialog.open();
                    switch (ret) {
                        case 0: {
                            filesToImport.add(config);
                            break;
                        }
                        case 1: {
                            owall = true;
                            filesToImport.add(config);
                            break;
                        }
                        case 3: {
                            nowall = true;
                            break;
                        }
                        case 4: {
                            return true;
                        }
                    }
                    continue;
                }
                if (nowall) continue;
                filesToImport.add(config);
                continue;
            }
            filesToImport.add(config);
        }
        if (!filesToImport.isEmpty()) {
            Job job = new Job(WizardMessages.ExportLaunchConfigurationsWizard_0){

                public IStatus run(IProgressMonitor monitor) {
                    LaunchManager launchManager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                    try {
                        launchManager.importConfigurations(filesToImport.toArray(new File[filesToImport.size()]), monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return true;
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_WIZBAN_IMPORT_CONFIGS");
    }

    protected void updateWidgetEnablements() {
        this.setPageComplete(this.determinePageCompletion());
    }

    protected boolean determinePageCompletion() {
        if (this.fFromDirectory.getText().trim().equals("")) {
            this.setErrorMessage(WizardMessages.ImportLaunchConfigurationsWizardPage_3);
            return false;
        }
        if (this.getSelectedResources().size() < 1) {
            this.setErrorMessage(WizardMessages.ImportLaunchConfigurationsWizardPage_4);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(WizardMessages.ImportLaunchConfigurationsWizardPage_5);
        return true;
    }

    protected void createSourceGroup(Composite parent) {
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 3, 1, 768, 0, 0);
        SWTFactory.createLabel(comp, WizardMessages.ImportLaunchConfigurationsWizardPage_6, 1);
        this.fFromDirectory = SWTFactory.createText(comp, 2060, 1, 768);
        Button browse = SWTFactory.createPushButton(comp, WizardMessages.ImportLaunchConfigurationsWizardPage_7, null);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Path path;
                DirectoryDialog dd = new DirectoryDialog(ImportLaunchConfigurationsWizardPage.this.getContainer().getShell(), 0x10000000);
                dd.setText(WizardMessages.ImportLaunchConfigurationsWizardPage_0);
                String filename = dd.open();
                if (filename != null && (path = new Path(filename)) != null) {
                    ImportLaunchConfigurationsWizardPage.this.fFromDirectory.setText(path.toString());
                    ImportLaunchConfigurationsWizardPage.this.resetSelection((IPath)path);
                    ImportLaunchConfigurationsWizardPage.this.setPageComplete(ImportLaunchConfigurationsWizardPage.this.determinePageCompletion());
                }
            }
        });
    }

    protected void resetSelection(IPath path) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            File file = new File(path.toOSString());
            DebugFileSystemElement dummyparent = new DebugFileSystemElement("", null, true);
            dummyparent.setPopulated();
            DebugFileSystemElement element = new DebugFileSystemElement(FileSystemStructureProvider.INSTANCE.getLabel((Object)file), dummyparent, file.isDirectory());
            element.setFileSystemObject(file);
            element.getFiles();
            this.selectionGroup.setRoot((Object)dummyparent);
        });
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof DebugFileSystemElement) {
                    DebugFileSystemElement element = (DebugFileSystemElement)((Object)o);
                    return element.getFiles().getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof DebugFileSystemElement) {
                    DebugFileSystemElement element = (DebugFileSystemElement)((Object)o);
                    return element.getFolders().getChildren();
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof DebugFileSystemElement) {
                    DebugFileSystemElement element = (DebugFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    class DebugFileSystemElement
    extends FileSystemElement {
        private boolean populated;

        public DebugFileSystemElement(String name, FileSystemElement parent, boolean isDirectory) {
            super(name, parent, isDirectory);
            this.populated = false;
        }

        public void setPopulated() {
            this.populated = true;
        }

        public boolean isPopulated() {
            return this.populated;
        }

        public AdaptableList getFiles() {
            if (!this.populated) {
                this.populateElementChildren();
            }
            return super.getFiles();
        }

        public AdaptableList getFolders() {
            if (!this.populated) {
                this.populateElementChildren();
            }
            return super.getFolders();
        }

        private void populateElementChildren() {
            FileSystemStructureProvider provider = FileSystemStructureProvider.INSTANCE;
            List allchildren = provider.getChildren(this.getFileSystemObject());
            DebugFileSystemElement newelement = null;
            for (File child : allchildren) {
                if (child.isFile()) {
                    Path childpath = new Path(child.getAbsolutePath());
                    String extension = childpath.getFileExtension();
                    if (extension == null || !extension.equals("launch") && !extension.equals("prototype")) continue;
                    newelement = new DebugFileSystemElement(provider.getLabel((Object)child), this, provider.isFolder((Object)child));
                    newelement.setFileSystemObject(child);
                    continue;
                }
                newelement = new DebugFileSystemElement(provider.getLabel((Object)child), this, provider.isFolder((Object)child));
                newelement.setFileSystemObject(child);
            }
            this.setPopulated();
        }
    }
}

