/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.server.subsystem.sftp.AbstractSftpEventListenerManager;
import org.apache.sshd.server.subsystem.sftp.SftpErrorStatusDataHandler;
import org.apache.sshd.server.subsystem.sftp.SftpEventListenerManager;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessor;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessorManager;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public class SftpSubsystemFactory
extends AbstractSftpEventListenerManager
implements SubsystemFactory,
ExecutorServiceConfigurer,
SftpEventListenerManager,
SftpFileSystemAccessorManager {
    public static final String NAME = "sftp";
    public static final UnsupportedAttributePolicy DEFAULT_POLICY = UnsupportedAttributePolicy.Warn;
    private ExecutorService executors;
    private boolean shutdownExecutor;
    private UnsupportedAttributePolicy policy = DEFAULT_POLICY;
    private SftpFileSystemAccessor fileSystemAccessor = SftpFileSystemAccessor.DEFAULT;
    private SftpErrorStatusDataHandler errorStatusDataHandler = SftpErrorStatusDataHandler.DEFAULT;

    public String getName() {
        return NAME;
    }

    public ExecutorService getExecutorService() {
        return this.executors;
    }

    public void setExecutorService(ExecutorService service) {
        this.executors = service;
    }

    public boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    public void setShutdownOnExit(boolean shutdownOnExit) {
        this.shutdownExecutor = shutdownOnExit;
    }

    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.policy;
    }

    public void setUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
        this.policy = Objects.requireNonNull(p, "No policy");
    }

    @Override
    public SftpFileSystemAccessor getFileSystemAccessor() {
        return this.fileSystemAccessor;
    }

    @Override
    public void setFileSystemAccessor(SftpFileSystemAccessor accessor) {
        this.fileSystemAccessor = Objects.requireNonNull(accessor, "No accessor");
    }

    public SftpErrorStatusDataHandler getErrorStatusDataHandler() {
        return this.errorStatusDataHandler;
    }

    public void setErrorStatusDataHandler(SftpErrorStatusDataHandler handler) {
        this.errorStatusDataHandler = Objects.requireNonNull(handler, "No error status data handler provided");
    }

    public Command create() {
        SftpSubsystem subsystem = new SftpSubsystem(this.getExecutorService(), this.isShutdownOnExit(), this.getUnsupportedAttributePolicy(), this.getFileSystemAccessor(), this.getErrorStatusDataHandler());
        GenericUtils.forEach(this.getRegisteredListeners(), subsystem::addSftpEventListener);
        return subsystem;
    }

    public static class Builder
    extends AbstractSftpEventListenerManager
    implements ObjectBuilder<SftpSubsystemFactory> {
        private ExecutorService executors;
        private boolean shutdownExecutor;
        private UnsupportedAttributePolicy policy = DEFAULT_POLICY;
        private SftpFileSystemAccessor fileSystemAccessor = SftpFileSystemAccessor.DEFAULT;
        private SftpErrorStatusDataHandler errorStatusDataHandler = SftpErrorStatusDataHandler.DEFAULT;

        public Builder withExecutorService(ExecutorService service) {
            this.executors = service;
            return this;
        }

        public Builder withShutdownOnExit(boolean shutdown) {
            this.shutdownExecutor = shutdown;
            return this;
        }

        public Builder withUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
            this.policy = Objects.requireNonNull(p, "No policy");
            return this;
        }

        public Builder withFileSystemAccessor(SftpFileSystemAccessor accessor) {
            this.fileSystemAccessor = Objects.requireNonNull(accessor, "No accessor");
            return this;
        }

        public Builder withSftpErrorStatusDataHandler(SftpErrorStatusDataHandler handler) {
            this.errorStatusDataHandler = Objects.requireNonNull(handler, "No error status handler");
            return this;
        }

        public SftpSubsystemFactory build() {
            SftpSubsystemFactory factory = new SftpSubsystemFactory();
            factory.setExecutorService(this.executors);
            factory.setShutdownOnExit(this.shutdownExecutor);
            factory.setUnsupportedAttributePolicy(this.policy);
            factory.setFileSystemAccessor(this.fileSystemAccessor);
            factory.setErrorStatusDataHandler(this.errorStatusDataHandler);
            GenericUtils.forEach(this.getRegisteredListeners(), factory::addSftpEventListener);
            return factory;
        }
    }
}

