/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.IntroduceParameterObjectProcessor;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.jdt.internal.ui.refactoring.InputPageUtil;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IntroduceParameterObjectWizard
extends RefactoringWizard {
    private final IntroduceParameterObjectProcessor fProcessor;

    public IntroduceParameterObjectWizard(IntroduceParameterObjectProcessor processor, Refactoring refactoring) {
        super(refactoring, 4);
        this.fProcessor = processor;
        this.setDefaultPageTitle(RefactoringMessages.IntroduceParameterObjectWizard_wizardpage_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new IntroduceParameterObjectInputPage(this.fProcessor));
    }

    private static class IntroduceParameterObjectInputPage
    extends UserInputWizardPage {
        private static final String CREATE_TOP_LEVEL_SETTING = "CreateTopLevel";
        private static final String CREATE_SETTERS_SETTING = "CreateSetters";
        private static final String CREATE_GETTERS_SETTING = "CreateGetters";
        private IntroduceParameterObjectProcessor fProcessor;
        private JavaSourceViewer fSignaturePreview;
        private Button fLeaveDelegateCheckBox;
        private Button fDeprecateDelegateCheckBox;

        public IntroduceParameterObjectInputPage(IntroduceParameterObjectProcessor processor) {
            super(RefactoringMessages.IntroduceParameterObjectWizard_wizardpage_name);
            this.fProcessor = processor;
            this.setTitle(RefactoringMessages.IntroduceParameterObjectWizard_wizardpage_title);
            this.setDescription(RefactoringMessages.IntroduceParameterObjectWizard_wizardpage_description);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite result = new Composite(parent, 0);
            result.setLayout((Layout)new GridLayout(2, false));
            Group group = this.createGroup(result, RefactoringMessages.IntroduceParameterObjectWizard_type_group);
            this.createClassNameInput((Composite)group);
            this.createLocationInput((Composite)group);
            this.createTable((Composite)group);
            this.createGetterInput((Composite)group);
            this.createSetterInput((Composite)group);
            group = this.createGroup(result, RefactoringMessages.IntroduceParameterObjectWizard_method_group);
            this.createParameterNameInput(group);
            this.createDelegateInput(group);
            this.createSignaturePreview((Composite)group);
            this.validateRefactoring();
            this.setControl((Control)result);
        }

        private void createParameterNameInput(Group group) {
            Label l = new Label((Composite)group, 0);
            l.setText(RefactoringMessages.IntroduceParameterObjectWizard_parameterfield_label);
            final Text text = new Text((Composite)group, 2048);
            text.setText(this.fProcessor.getParameterName());
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IntroduceParameterObjectInputPage.this.fProcessor.setParameterName(text.getText());
                    IntroduceParameterObjectInputPage.this.updateSignaturePreview();
                    IntroduceParameterObjectInputPage.this.validateRefactoring();
                }
            });
            text.setLayoutData((Object)new GridData(768));
        }

        protected void validateRefactoring() {
            IStatus validatePackageName;
            ArrayList<String> names = new ArrayList<String>();
            boolean oneChecked = false;
            this.setMessage(null);
            this.setErrorMessage(null);
            this.setPageComplete(true);
            IJavaProject project = this.fProcessor.getMethod().getJavaProject();
            String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
            String compliance = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            List<ParameterInfo> parameterInfos = this.fProcessor.getParameterInfos();
            for (ParameterInfo pi : parameterInfos) {
                if (names.contains(pi.getNewName())) {
                    this.setErrorMessage(Messages.format(RefactoringMessages.IntroduceParameterObjectWizard_parametername_check_notunique, BasicElementLabels.getJavaElementName(pi.getNewName())));
                    this.setPageComplete(false);
                    return;
                }
                names.add(pi.getNewName());
                IStatus validateIdentifier = JavaConventions.validateIdentifier((String)pi.getNewName(), (String)sourceLevel, (String)compliance);
                if (this.isErrorMessage(validateIdentifier)) {
                    return;
                }
                if (!pi.isCreateField()) continue;
                oneChecked = true;
            }
            if (!oneChecked) {
                this.setErrorMessage(RefactoringMessages.IntroduceParameterObjectWizard_parametername_check_atleastoneparameter);
                this.setPageComplete(false);
                return;
            }
            IStatus validateJavaTypeName = JavaConventions.validateJavaTypeName((String)this.fProcessor.getClassName(), (String)sourceLevel, (String)compliance);
            if (this.isErrorMessage(validateJavaTypeName)) {
                return;
            }
            if (this.fProcessor.getClassName().indexOf(46) != -1) {
                this.setErrorMessage(RefactoringMessages.IntroduceParameterObjectWizard_dot_not_allowed_error);
                this.setPageComplete(false);
            }
            if (!"".equals(this.fProcessor.getPackage()) && this.isErrorMessage(validatePackageName = JavaConventions.validatePackageName((String)this.fProcessor.getPackage(), (String)sourceLevel, (String)compliance))) {
                return;
            }
            try {
                IType type = project.findType(this.fProcessor.getNewTypeName());
                if (type != null) {
                    String packageLabel = JavaElementLabels.getElementLabel((IJavaElement)type.getPackageFragment(), JavaElementLabels.ALL_DEFAULT);
                    if (this.fProcessor.isCreateAsTopLevel()) {
                        this.setErrorMessage(Messages.format(RefactoringMessages.IntroduceParameterObjectWizard_type_already_exists_in_package_info, new Object[]{BasicElementLabels.getJavaElementName(this.fProcessor.getClassName()), packageLabel}));
                        this.setPageComplete(false);
                        return;
                    }
                    this.setErrorMessage(Messages.format(RefactoringMessages.IntroduceParameterObjectWizard_parametername_check_alreadyexists, new Object[]{BasicElementLabels.getJavaElementName(this.fProcessor.getClassName()), BasicElementLabels.getFileName((ITypeRoot)type.getCompilationUnit())}));
                    this.setPageComplete(false);
                    return;
                }
            }
            catch (JavaModelException javaModelException) {}
        }

        private boolean isErrorMessage(IStatus validationStatus) {
            if (!validationStatus.isOK()) {
                if (validationStatus.getSeverity() == 4) {
                    this.setErrorMessage(validationStatus.getMessage());
                    this.setPageComplete(false);
                    return true;
                }
                if (validationStatus.getSeverity() == 1) {
                    this.setMessage(validationStatus.getMessage(), 1);
                } else {
                    this.setMessage(validationStatus.getMessage(), 2);
                }
            }
            return false;
        }

        private void createSignaturePreview(Composite composite) {
            Label previewLabel = new Label(composite, 0);
            previewLabel.setText(RefactoringMessages.IntroduceParameterObjectWizard_signaturepreview_label);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            previewLabel.setLayoutData((Object)gridData);
            this.fSignaturePreview = InputPageUtil.createSignaturePreview(composite);
            ((GridData)this.fSignaturePreview.getControl().getLayoutData()).horizontalSpan = 2;
            this.updateSignaturePreview();
        }

        private void createDelegateInput(Group group) {
            this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox((Composite)group, this.getRefactoring(), false);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.fLeaveDelegateCheckBox.setLayoutData((Object)gridData);
            if (this.fLeaveDelegateCheckBox != null) {
                this.fDeprecateDelegateCheckBox = new Button((Composite)group, 32);
                GridData data = new GridData();
                data.horizontalAlignment = 4;
                GridLayout layout = (GridLayout)group.getLayout();
                data.horizontalIndent = layout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                data.horizontalSpan = 2;
                this.fDeprecateDelegateCheckBox.setLayoutData((Object)data);
                this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                final IntroduceParameterObjectProcessor refactoring = this.fProcessor;
                this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(refactoring));
                refactoring.setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        refactoring.setDeprecateDelegates(IntroduceParameterObjectInputPage.this.fDeprecateDelegateCheckBox.getSelection());
                        IntroduceParameterObjectInputPage.this.validateRefactoring();
                    }
                });
                this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IntroduceParameterObjectInputPage.this.fDeprecateDelegateCheckBox.setEnabled(IntroduceParameterObjectInputPage.this.fLeaveDelegateCheckBox.getSelection());
                    }
                });
            }
        }

        private Group createGroup(Composite result, String caption) {
            Group group = new Group(result, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setText(caption);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            group.setLayoutData((Object)gridData);
            return group;
        }

        private void createLocationInput(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(RefactoringMessages.IntroduceParameterObjectWizard_destination_label);
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            composite.setLayoutData((Object)gridData);
            final Button topLvlRadio = new Button(composite, 16);
            topLvlRadio.setText(RefactoringMessages.IntroduceParameterObjectWizard_createastoplevel_radio);
            topLvlRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean fAsTopLevel = topLvlRadio.getSelection();
                    IntroduceParameterObjectInputPage.this.fProcessor.setCreateAsTopLevel(fAsTopLevel);
                    IntroduceParameterObjectInputPage.this.updateSignaturePreview();
                    IntroduceParameterObjectInputPage.this.validateRefactoring();
                }
            });
            Button nestedRadio = new Button(composite, 16);
            nestedRadio.setText(Messages.format(RefactoringMessages.IntroduceParameterObjectWizard_createasnestedclass_radio, BasicElementLabels.getJavaElementName(this.fProcessor.getContainingClass().getName())));
            boolean createAsTopLevel = this.getBooleanSetting(CREATE_TOP_LEVEL_SETTING, this.fProcessor.isCreateAsTopLevel());
            this.fProcessor.setCreateAsTopLevel(createAsTopLevel);
            topLvlRadio.setSelection(createAsTopLevel);
            nestedRadio.setSelection(!createAsTopLevel);
        }

        private void createTable(Composite parent) {
            Composite result = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            result.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            result.setLayoutData((Object)gridData);
            Label l = new Label(result, 0);
            l.setText(RefactoringMessages.IntroduceParameterObjectWizard_fields_selection_label);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.verticalIndent = 5;
            l.setLayoutData((Object)gridData);
            Composite layoutComposite = new Composite(result, 0);
            final CheckboxTableViewer tv = CheckboxTableViewer.newCheckList((Composite)layoutComposite, (int)68354);
            tv.setContentProvider((IContentProvider)new ParameterObjectCreatorContentProvider());
            this.createColumns(tv);
            Table table = tv.getTable();
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            gridData = new GridData(1808);
            table.setLayoutData((Object)gridData);
            tv.setInput((Object)this.fProcessor);
            List<ParameterInfo> parameterInfos = this.fProcessor.getParameterInfos();
            for (ParameterInfo pi : parameterInfos) {
                tv.setChecked((Object)pi, pi.isCreateField());
            }
            tv.refresh(true);
            gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.getTableHeightHint(table, parameterInfos.size());
            gridData.widthHint = this.convertWidthInCharsToPixels(30);
            layoutComposite.setLayoutData((Object)gridData);
            Composite controls = new Composite(result, 0);
            gridData = new GridData(4, 4, false, false);
            controls.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            controls.setLayout((Layout)gridLayout);
            final Button upButton = new Button(controls, 0);
            upButton.setText(RefactoringMessages.IntroduceParameterObjectWizard_moveentryup_button);
            gridData = new GridData(768);
            upButton.setLayoutData((Object)gridData);
            SWTUtil.setButtonDimensionHint(upButton);
            upButton.setEnabled(false);
            final Button downButton = new Button(controls, 0);
            downButton.setText(RefactoringMessages.IntroduceParameterObjectWizard_moventrydown_button);
            gridData = new GridData(768);
            downButton.setLayoutData((Object)gridData);
            SWTUtil.setButtonDimensionHint(downButton);
            downButton.setEnabled(false);
            this.addSpacer(controls);
            final Button editButton = new Button(controls, 0);
            editButton.setText(RefactoringMessages.IntroduceParameterObjectWizard_edit_button);
            editButton.setLayoutData((Object)new GridData(768));
            editButton.setEnabled(!tv.getSelection().isEmpty());
            SWTUtil.setButtonDimensionHint(editButton);
            editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = tv.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        ParameterInfo selected = (ParameterInfo)ss.getFirstElement();
                        String message = RefactoringMessages.IntroduceParameterObjectWizard_fieldname_message;
                        String title = RefactoringMessages.IntroduceParameterObjectWizard_fieldname_title;
                        InputDialog inputDialog = new InputDialog(IntroduceParameterObjectInputPage.this.getShell(), title, message, selected.getNewName(), new IInputValidator(){

                            public String isValid(String newText) {
                                IStatus status = JavaConventionsUtil.validateIdentifier(newText, (IJavaElement)IntroduceParameterObjectInputPage.this.fProcessor.getCompilationUnit());
                                if (!status.isOK()) {
                                    return status.getMessage();
                                }
                                return null;
                            }
                        });
                        if (inputDialog.open() == 0) {
                            selected.setNewName(inputDialog.getValue());
                            tv.refresh((Object)selected);
                            IntroduceParameterObjectInputPage.this.updateSignaturePreview();
                        }
                    }
                }
            });
            downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int[] indices = tv.getTable().getSelectionIndices();
                    Arrays.sort(indices);
                    int i = indices.length - 1;
                    while (i >= 0) {
                        int idx = indices[i];
                        ParameterInfo pi = (ParameterInfo)tv.getElementAt(idx);
                        IntroduceParameterObjectInputPage.this.fProcessor.moveFieldDown(pi);
                        --i;
                    }
                    tv.refresh();
                    IntroduceParameterObjectInputPage.this.updateButtons((TableViewer)tv, upButton, downButton, editButton);
                }
            });
            upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int[] indices = tv.getTable().getSelectionIndices();
                    Arrays.sort(indices);
                    int i = 0;
                    while (i < indices.length) {
                        int idx = indices[i];
                        ParameterInfo pi = (ParameterInfo)tv.getElementAt(idx);
                        IntroduceParameterObjectInputPage.this.fProcessor.moveFieldUp(pi);
                        ++i;
                    }
                    tv.refresh();
                    IntroduceParameterObjectInputPage.this.updateButtons((TableViewer)tv, upButton, downButton, editButton);
                }
            });
            tv.addCheckStateListener(new ICheckStateListener(){
                Map<ParameterInfo, String> fLastNames = new HashMap<ParameterInfo, String>();

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ParameterInfo element = (ParameterInfo)event.getElement();
                    element.setCreateField(event.getChecked());
                    if (element.isCreateField()) {
                        String lastName = this.fLastNames.get(element);
                        if (lastName == null) {
                            lastName = IntroduceParameterObjectInputPage.this.fProcessor.getFieldName(element);
                        }
                        element.setNewName(lastName);
                    } else {
                        this.fLastNames.put(element, element.getNewName());
                        element.setNewName(element.getOldName());
                    }
                    tv.update((Object)element, null);
                    IntroduceParameterObjectInputPage.this.updateButtons((TableViewer)tv, upButton, downButton, editButton);
                    IntroduceParameterObjectInputPage.this.validateRefactoring();
                }
            });
            tv.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IntroduceParameterObjectInputPage.this.updateButtons((TableViewer)tv, upButton, downButton, editButton);
                }
            });
        }

        private void addSpacer(Composite parent) {
            Label label = new Label(parent, 0);
            GridData gd = new GridData(768);
            gd.heightHint = 5;
            label.setLayoutData((Object)gd);
        }

        private void createColumns(CheckboxTableViewer tv) {
            TextCellEditor cellEditor = new TextCellEditor((Composite)tv.getTable());
            TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)tv, 16384);
            viewerColumn.setLabelProvider((CellLabelProvider)new ParameterInfoLabelProvider(this){

                protected String doGetValue(ParameterInfo pi) {
                    return pi.getNewTypeName();
                }
            });
            TableColumn columnType = viewerColumn.getColumn();
            columnType.setText(RefactoringMessages.IntroduceParameterObjectWizard_type_column);
            viewerColumn = new TableViewerColumn((TableViewer)tv, 16384);
            viewerColumn.setLabelProvider((CellLabelProvider)new ParameterInfoLabelProvider(this){

                protected String doGetValue(ParameterInfo pi) {
                    return pi.getNewName();
                }
            });
            viewerColumn.setEditingSupport((EditingSupport)new ParameterInfoEditingSupport(this, (CellEditor)cellEditor, (ColumnViewer)tv){

                public String doGetValue(ParameterInfo pi) {
                    return pi.getNewName();
                }

                public void doSetValue(ParameterInfo pi, String string) {
                    pi.setNewName(string);
                }
            });
            TableColumn columnName = viewerColumn.getColumn();
            columnName.setText(RefactoringMessages.IntroduceParameterObjectWizard_name_column);
            TableColumnLayout layout = new TableColumnLayout();
            layout.setColumnData((Widget)columnType, (ColumnLayoutData)new ColumnWeightData(50, this.convertWidthInCharsToPixels(20), true));
            layout.setColumnData((Widget)columnName, (ColumnLayoutData)new ColumnWeightData(50, this.convertWidthInCharsToPixels(20), true));
            tv.getTable().getParent().setLayout((Layout)layout);
        }

        private void createGetterInput(Composite result) {
            Composite buttons = new Composite(result, 0);
            GridLayout gridLayout = new GridLayout(2, true);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttons.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            buttons.setLayoutData((Object)gridData);
            final Button button = new Button(buttons, 32);
            button.setText(RefactoringMessages.IntroduceParameterObjectWizard_creategetter_checkbox);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IntroduceParameterObjectInputPage.this.fProcessor.setCreateGetter(button.getSelection());
                    IntroduceParameterObjectInputPage.this.validateRefactoring();
                }
            });
            button.setSelection(this.getBooleanSetting(CREATE_GETTERS_SETTING, this.fProcessor.isCreateGetter()));
            this.fProcessor.setCreateGetter(button.getSelection());
            gridData = new GridData();
            button.setLayoutData((Object)gridData);
        }

        private void createSetterInput(Composite result) {
            final Button button = new Button(result, 32);
            button.setText(RefactoringMessages.IntroduceParameterObjectWizard_createsetter_checkbox);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IntroduceParameterObjectInputPage.this.fProcessor.setCreateSetter(button.getSelection());
                    IntroduceParameterObjectInputPage.this.validateRefactoring();
                }
            });
            button.setSelection(this.getBooleanSetting(CREATE_SETTERS_SETTING, this.fProcessor.isCreateSetter()));
            this.fProcessor.setCreateSetter(button.getSelection());
            GridData gridData = new GridData();
            button.setLayoutData((Object)gridData);
        }

        private void createClassNameInput(Composite result) {
            Label label = new Label(result, 16384);
            label.setText(RefactoringMessages.IntroduceParameterObjectWizard_classnamefield_label);
            final Text text = new Text(result, 2052);
            text.setText(this.fProcessor.getClassName());
            text.selectAll();
            text.setFocus();
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IntroduceParameterObjectInputPage.this.fProcessor.setClassName(text.getText());
                    IntroduceParameterObjectInputPage.this.updateSignaturePreview();
                    IntroduceParameterObjectInputPage.this.validateRefactoring();
                }
            });
            text.setLayoutData((Object)new GridData(768));
        }

        private void updateButtons(TableViewer tv, Button upButton, Button downButton, Button editButton) {
            IStructuredSelection selection = (IStructuredSelection)tv.getSelection();
            ParameterInfo firstElement = (ParameterInfo)selection.getFirstElement();
            if (selection.isEmpty()) {
                upButton.setEnabled(false);
                downButton.setEnabled(false);
                editButton.setEnabled(false);
            } else {
                int[] selectionIndex = tv.getTable().getSelectionIndices();
                upButton.setEnabled(selectionIndex[0] != 0);
                downButton.setEnabled(selectionIndex[selectionIndex.length - 1] != tv.getTable().getItemCount() - 1);
                editButton.setEnabled(firstElement.isCreateField() && selectionIndex.length == 1);
            }
            this.fProcessor.updateParameterPosition();
            this.updateSignaturePreview();
        }

        private void updateSignaturePreview() {
            try {
                int top = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreview.getDocument().set(this.fProcessor.getNewMethodSignature());
                this.fSignaturePreview.getTextWidget().setTopPixel(top);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.IntroduceParameterObjectWizard_error_title, RefactoringMessages.IntroduceParameterObjectWizard_error_description);
            }
        }

        public void dispose() {
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            IDialogSettings settings = this.getRefactoringSettings();
            settings.put(CREATE_GETTERS_SETTING, this.fProcessor.isCreateGetter());
            settings.put(CREATE_SETTERS_SETTING, this.fProcessor.isCreateSetter());
            settings.put(CREATE_TOP_LEVEL_SETTING, this.fProcessor.isCreateAsTopLevel());
            super.dispose();
        }

        protected boolean getBooleanSetting(String key, boolean defaultValue) {
            String update = this.getRefactoringSettings().get(key);
            if (update != null) {
                return Boolean.valueOf(update);
            }
            return defaultValue;
        }

        private abstract class ParameterInfoEditingSupport
        extends EditingSupport {
            private CellEditor fTextEditor;

            private ParameterInfoEditingSupport(CellEditor textEditor, ColumnViewer tv) {
                super(tv);
                this.fTextEditor = textEditor;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof ParameterInfo) {
                    ParameterInfo pi = (ParameterInfo)element;
                    this.doSetValue(pi, value.toString());
                    this.getViewer().update(element, null);
                }
                IntroduceParameterObjectInputPage.this.validateRefactoring();
                IntroduceParameterObjectInputPage.this.updateSignaturePreview();
            }

            public abstract void doSetValue(ParameterInfo var1, String var2);

            protected Object getValue(Object element) {
                if (element instanceof ParameterInfo) {
                    ParameterInfo pi = (ParameterInfo)element;
                    return this.doGetValue(pi);
                }
                return null;
            }

            public abstract String doGetValue(ParameterInfo var1);

            protected CellEditor getCellEditor(Object element) {
                return this.fTextEditor;
            }

            protected boolean canEdit(Object element) {
                if (element instanceof ParameterInfo) {
                    ParameterInfo pi = (ParameterInfo)element;
                    return this.fTextEditor != null && pi.isCreateField();
                }
                return false;
            }
        }

        private abstract class ParameterInfoLabelProvider
        extends CellLabelProvider {
            private ParameterInfoLabelProvider() {
            }

            public void update(ViewerCell cell) {
                ParameterInfo pi = (ParameterInfo)cell.getElement();
                cell.setText(this.doGetValue(pi));
            }

            protected abstract String doGetValue(ParameterInfo var1);
        }

        private final class ParameterObjectCreatorContentProvider
        implements IStructuredContentProvider {
            private ParameterObjectCreatorContentProvider() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IntroduceParameterObjectProcessor) {
                    IntroduceParameterObjectProcessor refactoring = (IntroduceParameterObjectProcessor)inputElement;
                    List<ParameterInfo> parameterInfos = refactoring.getParameterInfos();
                    ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(parameterInfos.size());
                    for (ParameterInfo pi : parameterInfos) {
                        if (pi.isAdded()) continue;
                        result.add(pi);
                    }
                    return result.toArray();
                }
                return null;
            }
        }
    }
}

