/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UseScanParser {
    private UseScanVisitor visitor;
    private IComponentDescriptor targetComponent;
    private IComponentDescriptor referencingComponent;
    private IMemberDescriptor targetMember;
    private int referenceKind;
    private int visibility;
    private boolean visitReferencingComponent = true;
    private boolean visitMembers = true;
    private boolean visitReferences = true;

    protected String[] getIdVersion(String value) {
        int index = value.indexOf(32);
        if (index > 0) {
            String id = value.substring(0, index);
            String version = value.substring(index + 1);
            if (version.startsWith("(") && (version = version.substring(1)).endsWith(")")) {
                version = version.substring(0, version.length() - 1);
            }
            return new String[]{id, version};
        }
        String[] stringArray = new String[2];
        stringArray[0] = value;
        return stringArray;
    }

    protected void processElement(String uri, String localName, String name, Attributes attributes, int type) throws SAXException {
        if ("references".equals(name)) {
            String source;
            IComponentDescriptor sourceComponent;
            String target = attributes.getValue("referee");
            String[] idv = this.getIdVersion(target);
            IComponentDescriptor tcomp = Factory.componentDescriptor(idv[0], idv[1]);
            if (!tcomp.equals(this.targetComponent)) {
                System.out.println("WARNING: The referee in the xml file (" + tcomp + ") does not match the directory name (" + this.targetComponent + ")");
            }
            if (!(sourceComponent = Factory.componentDescriptor((idv = this.getIdVersion(source = attributes.getValue("origin")))[0], idv[1])).equals(this.referencingComponent)) {
                System.out.println("WARNING: The origin in the xml file (" + sourceComponent + ") does not match the directory name (" + this.referencingComponent + ")");
            }
            String visString = attributes.getValue("reference_visibility");
            try {
                int vis = Integer.parseInt(visString);
                this.enterVisibility(vis);
            }
            catch (NumberFormatException numberFormatException) {
                this.enterVisibility(-1);
                System.out.println("Internal error: invalid visibility: " + visString);
            }
        } else if ("target".equals(name)) {
            String qName = attributes.getValue("type");
            String memberName = attributes.getValue("member");
            String signature = attributes.getValue("signature");
            IMemberDescriptor member = null;
            switch (type) {
                case 1: {
                    member = Factory.typeDescriptor(qName);
                    break;
                }
                case 3: {
                    member = Factory.methodDescriptor(qName, memberName, signature);
                    break;
                }
                case 2: {
                    member = Factory.fieldDescriptor(qName, memberName);
                    break;
                }
            }
            this.enterTargetMember(member);
        } else if ("reference_kind".equals(name)) {
            String value = attributes.getValue("kind");
            if (value != null) {
                try {
                    this.enterReferenceKind(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(NLS.bind((String)"Internal error: invalid reference kind: {0}", (Object)value));
                }
            }
        } else if ("reference".equals(name)) {
            String qName = attributes.getValue("type");
            if (qName != null) {
                String memberName = attributes.getValue("member");
                String signature = attributes.getValue("signature");
                IMemberDescriptor origin = null;
                origin = signature != null ? Factory.methodDescriptor(qName, memberName, signature) : (memberName != null ? Factory.fieldDescriptor(qName, memberName) : Factory.typeDescriptor(qName));
                String line = attributes.getValue("linenumber");
                String flags = attributes.getValue("flags");
                try {
                    int num = Integer.parseInt(line);
                    int flgs = 0;
                    if (flags != null) {
                        flgs = Integer.parseInt(flags);
                    }
                    this.setReference(Factory.referenceDescriptor(this.referencingComponent, origin, num, this.targetComponent, this.targetMember, this.referenceKind, flgs, this.visibility, this.parseMessages(attributes)));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Internal error: invalid line number: " + line);
                }
            } else {
                System.out.println(NLS.bind((String)"Element {0} is missing type attribute and will be skipped", (Object)this.targetMember.getName()));
            }
        }
    }

    protected String[] parseMessages(Attributes attribs) {
        String msgs = attribs.getValue("message_arguments");
        String[] messages = null;
        if (msgs != null) {
            messages = msgs.split("\\,");
        }
        return messages;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(String xmlLocation, IProgressMonitor monitor, UseScanVisitor usv) throws Exception {
        if (xmlLocation == null) {
            throw new Exception(SearchMessages.missing_xml_files_location);
        }
        this.visitor = usv;
        reportsRoot = new File(xmlLocation);
        if (!reportsRoot.exists() || !reportsRoot.isDirectory()) {
            throw new Exception(NLS.bind((String)SearchMessages.invalid_directory_name, (Object)xmlLocation));
        }
        localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.UseScanParser_parsing, (int)8);
        localmonitor.subTask(SearchMessages.UseReportConverter_collecting_dir_info);
        referees = this.getDirectories(reportsRoot);
        Util.updateMonitor((IProgressMonitor)localmonitor, 1);
        origins = null;
        xmlfiles = null;
        localmonitor.setWorkRemaining(referees.length);
        this.visitor.visitScan();
        try {
            parser = this.getParser();
            i = 0;
            while (i < referees.length) {
                if (referees[i].isDirectory()) {
                    idv = this.getIdVersion(referees[i].getName());
                    tcomp = Factory.componentDescriptor(idv[0], idv[1]);
                    this.enterTargetComponent(tcomp);
                    if (this.visitReferencingComponent) {
                        origins = this.getDirectories(referees[i]);
                        origins = this.sort(origins);
                        j = 0;
                        while (j < origins.length) {
                            if (origins[j].isDirectory()) {
                                idv = this.getIdVersion(origins[j].getName());
                                rcomp = Factory.componentDescriptor(idv[0], idv[1]);
                                this.enterReferencingComponent(rcomp);
                                if (this.visitMembers) {
                                    localmonitor.subTask(NLS.bind((String)SearchMessages.UseScanParser_analyzing_references, (Object[])new String[]{origins[j].getName()}));
                                    xmlfiles = Util.getAllFiles(origins[j], new FileFilter(){

                                        @Override
                                        public boolean accept(File pathname) {
                                            return pathname.isDirectory() || pathname.getName().endsWith(".xml");
                                        }
                                    });
                                    if (xmlfiles != null && xmlfiles.length > 0) {
                                        xmlfiles = this.sort(xmlfiles);
                                        k = 0;
                                        while (k < xmlfiles.length) {
                                            block30: {
                                                inputFile = null;
                                                try {
                                                    handler = new ReferenceHandler(this.getTypeFromFileName(xmlfiles[k]));
                                                    inputFile = new FileInputStream(xmlfiles[k].getAbsoluteFile());
                                                    parser.parse(inputFile, (DefaultHandler)handler);
                                                }
                                                catch (SAXException v0) {
                                                    if (inputFile != null) {
                                                        try {
                                                            inputFile.close();
                                                        }
                                                        catch (IOException v1) {}
                                                    }
                                                    break block30;
                                                }
                                                catch (IOException e) {
                                                    try {
                                                        ApiPlugin.log(e);
                                                        ** if (inputFile == null) goto lbl-1000
                                                    }
                                                    catch (Throwable var18_19) {
                                                        if (inputFile != null) {
                                                            try {
                                                                inputFile.close();
                                                            }
                                                            catch (IOException v3) {}
                                                        }
                                                        throw var18_19;
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        try {
                                                            inputFile.close();
                                                        }
                                                        catch (IOException v2) {}
                                                    }
lbl-1000:
                                                    // 2 sources

                                                    {
                                                        break block30;
                                                    }
                                                }
                                                if (inputFile == null) break block30;
                                                try {
                                                    inputFile.close();
                                                }
                                                catch (IOException v4) {}
                                            }
                                            ++k;
                                        }
                                    }
                                    this.endMember();
                                }
                                this.endReferencingComponent();
                            }
                            ++j;
                        }
                    }
                    Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                    this.endComponent();
                }
                ++i;
            }
        }
        finally {
            this.visitor.endVisitScan();
            localmonitor.done();
        }
    }

    SAXParser getParser() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            return factory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            throw new Exception(SearchMessages.UseReportConverter_pce_error_getting_parser, pce);
        }
        catch (SAXException se) {
            throw new Exception(SearchMessages.UseReportConverter_se_error_parser_handle, se);
        }
    }

    protected IComponentDescriptor getReferencingComponent() {
        return this.referencingComponent;
    }

    protected IComponentDescriptor getTargetComponent() {
        return this.targetComponent;
    }

    protected IMemberDescriptor getTargetMember() {
        return this.targetMember;
    }

    protected int getReferenceKind() {
        return this.referenceKind;
    }

    protected int getVisibility() {
        return this.visibility;
    }

    File[] getDirectories(File file) {
        File[] directories = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.isHidden();
            }
        });
        return directories;
    }

    private int getTypeFromFileName(File xmlfile) {
        if (xmlfile.getName().indexOf("type_references") > -1) {
            return 1;
        }
        if (xmlfile.getName().indexOf("method_references") > -1) {
            return 3;
        }
        return 2;
    }

    public void enterTargetComponent(IComponentDescriptor component) {
        boolean different = false;
        if (this.targetComponent == null) {
            different = true;
        } else if (!this.targetComponent.equals(component)) {
            different = true;
        }
        if (different) {
            this.endMember();
            this.endReferencingComponent();
            this.endComponent();
            this.targetComponent = component;
            this.visitReferencingComponent = this.visitor.visitComponent(this.targetComponent);
        }
    }

    public void enterReferencingComponent(IComponentDescriptor component) {
        boolean different = false;
        if (this.referencingComponent == null) {
            different = true;
        } else if (!this.referencingComponent.equals(component)) {
            different = true;
        }
        if (different) {
            this.endMember();
            this.endReferencingComponent();
            this.referencingComponent = component;
            if (this.visitReferencingComponent) {
                this.visitMembers = this.visitor.visitReferencingComponent(this.referencingComponent);
            }
        }
    }

    public void enterVisibility(int vis) {
        this.visibility = vis;
    }

    public void enterTargetMember(IMemberDescriptor member) {
        if (this.targetMember == null || !this.targetMember.equals(member)) {
            this.endMember();
            this.targetMember = member;
            if (this.visitReferencingComponent && this.visitMembers) {
                this.visitReferences = this.visitor.visitMember(this.targetMember);
            }
        }
    }

    public void enterReferenceKind(int refKind) {
        this.referenceKind = refKind;
    }

    public void setReference(IReferenceDescriptor reference) {
        if (this.visitReferencingComponent && this.visitMembers && this.visitReferences) {
            this.visitor.visitReference(reference);
        }
    }

    private void endMember() {
        if (this.targetMember != null) {
            if (this.visitReferencingComponent && this.visitMembers) {
                this.visitor.endVisitMember(this.targetMember);
            }
            this.targetMember = null;
        }
    }

    private void endReferencingComponent() {
        if (this.referencingComponent != null) {
            if (this.visitReferencingComponent) {
                this.visitor.endVisitReferencingComponent(this.referencingComponent);
            }
            this.referencingComponent = null;
        }
    }

    private void endComponent() {
        if (this.targetComponent != null) {
            this.visitor.endVisitComponent(this.targetComponent);
            this.targetComponent = null;
        }
    }

    File[] sort(File[] files) {
        ArrayList<File> sorted = new ArrayList<File>(files.length + 2);
        int i = 0;
        while (i < files.length) {
            sorted.add(files[i]);
            ++i;
        }
        Collections.sort(sorted, Util.filesorter);
        return sorted.toArray(new File[sorted.size()]);
    }

    class ReferenceHandler
    extends DefaultHandler {
        private int type = 0;

        public ReferenceHandler(int type) {
            this.type = type;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            UseScanParser.this.processElement(uri, localName, name, attributes, this.type);
        }
    }
}

