/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpContext;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.CtxHelpTreeSection;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details.CtxHelpAbstractDetails;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details.CtxHelpDetailsMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;

public class CtxHelpContextDetails
extends CtxHelpAbstractDetails {
    private CtxHelpContext fContext;
    private FormEntry fIdEntry;
    private FormEntry fTitleEntry;
    private FormEntry fDescEntry;

    public CtxHelpContextDetails(CtxHelpTreeSection masterSection) {
        super(masterSection, "ctxhelp-context");
    }

    public void createFields(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpContextDetails_idDesc);
        this.fIdEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpContextDetails_idLabel, 0);
        this.createSpace(parent);
        this.createLabel(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpContextDetails_descDesc);
        this.fDescEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpContextDetails_descText, 578);
        GridData data = new GridData(768);
        data.heightHint = 50;
        this.fDescEntry.getText().setLayoutData((Object)data);
        data = new GridData(130);
        this.fDescEntry.getLabel().setLayoutData((Object)data);
        this.createSpace(parent);
        this.createLabel(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpContextDetails_titleDesc);
        this.fTitleEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpContextDetails_titleTitle, 0);
    }

    protected String getDetailsTitle() {
        return CtxHelpDetailsMessages.CtxHelpContextDetails_title;
    }

    protected String getDetailsDescription() {
        return null;
    }

    public void hookListeners() {
        this.fIdEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (CtxHelpContextDetails.this.fContext != null) {
                    CtxHelpContextDetails.this.fContext.setID(CtxHelpContextDetails.this.fIdEntry.getValue());
                }
            }
        });
        this.fDescEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (CtxHelpContextDetails.this.fContext != null) {
                    if (CtxHelpContextDetails.this.fDescEntry.getValue().trim().length() > 0) {
                        CtxHelpContextDetails.this.fContext.setDescription(CtxHelpContextDetails.this.fDescEntry.getValue());
                    } else {
                        CtxHelpContextDetails.this.fContext.setDescription(null);
                    }
                }
            }
        });
        this.fTitleEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (CtxHelpContextDetails.this.fContext != null) {
                    CtxHelpContextDetails.this.fContext.setTitle(CtxHelpContextDetails.this.fTitleEntry.getValue());
                }
            }
        });
    }

    public void updateFields() {
        if (this.fContext != null) {
            this.fIdEntry.setValue(this.fContext.getId(), true);
            this.fIdEntry.setEditable(this.isEditableElement());
            this.fDescEntry.setValue(this.fContext.getDescription(), true);
            this.fDescEntry.setEditable(this.isEditableElement());
            this.fTitleEntry.setValue(this.fContext.getTitle(), true);
            this.fTitleEntry.setEditable(this.isEditableElement());
        }
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fIdEntry.commit();
        this.fDescEntry.commit();
        this.fTitleEntry.commit();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object instanceof CtxHelpContext) {
            this.fContext = (CtxHelpContext)object;
            this.updateFields();
        }
    }
}

