/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.conditions.mining.LicenseReadingService;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.access.SumOfCertificates;
import org.eclipse.passage.lic.base.diagnostic.SumOfLists;
import org.eclipse.passage.lic.internal.base.access.Library;

public final class Libraries {
    private final List<Library> libraries;
    private final Supplier<LicensedProduct> owner;

    public Libraries(Supplier<List<Library>> libraries, Supplier<LicensedProduct> owner) {
        this(libraries.get(), owner);
    }

    public Libraries(List<Library> libraries, Supplier<LicensedProduct> owner) {
        this.libraries = libraries;
        this.owner = owner;
    }

    public boolean empty() {
        return this.libraries.isEmpty();
    }

    public LicensedProduct product() {
        return this.owner.get();
    }

    public Optional<ServiceInvocationResult<ExaminationCertificate>> assess() {
        return this.libraries.stream().map(Library::assess).reduce(new BaseServiceInvocationResult.Sum<ExaminationCertificate>(new SumOfCertificates()));
    }

    public Optional<ServiceInvocationResult<List<AgreementAcceptanceService>>> agreementsServices(AgreementToAccept agreement) {
        return this.libraries.stream().map(library -> library.agreementsService(agreement)).map(this::enlisted).reduce(this.sum());
    }

    public Optional<ServiceInvocationResult<List<LicenseReadingService>>> licenseReadingServices() {
        return this.libraries.stream().map(Library::licenseReadingService).map(this::enlisted).reduce(this.sum());
    }

    public Optional<ServiceInvocationResult<Boolean>> installLicense(Path license) throws IOException {
        return this.libraries.stream().map(library -> library.installLicense(license)).reduce(new BaseServiceInvocationResult.Sum<Boolean>(this.or()));
    }

    private <T> ServiceInvocationResult<List<T>> enlisted(ServiceInvocationResult<T> origin) {
        List data = origin.data().isPresent() ? Arrays.asList(origin.data().get()) : Collections.emptyList();
        return new BaseServiceInvocationResult(origin.diagnostic(), data);
    }

    private <T> BaseServiceInvocationResult.Sum<List<T>> sum() {
        return new BaseServiceInvocationResult.Sum<List<T>>(new SumOfLists());
    }

    private BinaryOperator<Boolean> or() {
        return (first, second) -> first != false || second != false;
    }
}

