/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.licenses.model.migration;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.passage.lic.emf.migration.DelegateClassifiers;
import org.eclipse.passage.lic.emf.migration.EAttributeRoute;
import org.eclipse.passage.lic.emf.migration.EClassRoutes;
import org.eclipse.passage.lic.emf.migration.EReferenceRoute;
import org.eclipse.passage.lic.emf.migration.MigrationRoutes;
import org.eclipse.passage.lic.emf.migration.SimpleAttributeRoute;
import org.eclipse.passage.lic.emf.migration.SimpleClassRoutes;
import org.eclipse.passage.lic.emf.migration.SimpleMigrationRoutes;
import org.eclipse.passage.lic.emf.migration.SimpleReferenceRoute;
import org.eclipse.passage.lic.emf.xmi.MigratingResourceHandler;
import org.eclipse.passage.lic.internal.licenses.model.AssignGrantIdentifiers;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;

public class LicensesResourceHandler
extends MigratingResourceHandler {
    protected final void complete(XMLResource resource) {
        resource.getContents().stream().filter(PersonalLicensePack.class::isInstance).map(PersonalLicensePack.class::cast).forEach(new AssignGrantIdentifiers());
    }

    protected final void register() {
        this.migrate033();
        this.migrate040();
        this.migrate050();
        this.migrate100();
        this.migrate110();
        this.migrate200();
    }

    protected final MigrationRoutes attributes() {
        SimpleMigrationRoutes routes = new SimpleMigrationRoutes();
        LicensesPackage licenses = LicensesPackage.eINSTANCE;
        routes.define("licenseGrants", (EReferenceRoute)new SimpleReferenceRoute(licenses.getPersonalLicensePack_Grants()));
        routes.define("licensePack", (EReferenceRoute)new SimpleReferenceRoute(licenses.getPersonalFeatureGrant_Pack()));
        routes.define("licensePlanFeatures", (EReferenceRoute)new SimpleReferenceRoute(licenses.getLicensePlan_Features()));
        routes.define("licensePlan", (EReferenceRoute)new SimpleReferenceRoute(licenses.getLicensePlanFeature_Plan()));
        routes.define("conditionExpression", (EAttributeRoute)new SimpleAttributeRoute(licenses.getEvaluationInstructions_Expression(), new EReference[]{licenses.getPersonalFeatureGrant_UserAuthentication()}));
        routes.define("conditionType", (EAttributeRoute)new SimpleAttributeRoute(licenses.getEvaluationInstructions_Type(), new EReference[]{licenses.getPersonalFeatureGrant_UserAuthentication()}));
        routes.define("featureIdentifier", (EAttributeRoute)new SimpleAttributeRoute(licenses.getFeatureRef_Identifier(), new EReference[]{licenses.getPersonalFeatureGrant_Feature()}));
        routes.define("identifier", (EAttributeRoute)new SimpleAttributeRoute(licenses.getPersonalFeatureGrant_Identifier()));
        routes.define("identifier", (EAttributeRoute)new SimpleAttributeRoute(licenses.getLicenseRequisites_Identifier(), new EReference[]{licenses.getPersonalLicensePack_License()}));
        routes.define("issueDate", (EAttributeRoute)new SimpleAttributeRoute(licenses.getLicenseRequisites_IssueDate(), new EReference[]{licenses.getPersonalLicensePack_License()}));
        routes.define("matchRule", (EAttributeRoute)new SimpleAttributeRoute(licenses.getVersionMatch_Rule(), new EReference[]{licenses.getPersonalFeatureGrant_Feature(), licenses.getFeatureRef_VersionMatch()}));
        routes.define("matchVersion", (EAttributeRoute)new SimpleAttributeRoute(licenses.getVersionMatch_Version(), new EReference[]{licenses.getPersonalFeatureGrant_Feature(), licenses.getFeatureRef_VersionMatch()}));
        routes.define("planIdentifier", (EAttributeRoute)new SimpleAttributeRoute(licenses.getLicenseRequisites_Plan(), new EReference[]{licenses.getPersonalLicensePack_License()}));
        routes.define("productIdentifier", (EAttributeRoute)new SimpleAttributeRoute(licenses.getProductRef_Identifier(), new EReference[]{licenses.getPersonalLicensePack_License(), licenses.getLicenseRequisites_Product()}));
        routes.define("productVersion", (EAttributeRoute)new SimpleAttributeRoute(licenses.getProductRef_Version(), new EReference[]{licenses.getPersonalLicensePack_License(), licenses.getLicenseRequisites_Product()}));
        routes.define("userIdentifier", (EAttributeRoute)new SimpleAttributeRoute(licenses.getUserRef_Identifier(), new EReference[]{licenses.getPersonalLicensePack_License(), licenses.getPersonalLicenseRequisites_User()}));
        routes.define("userFullName", (EAttributeRoute)new SimpleAttributeRoute(licenses.getUserRef_Name(), new EReference[]{licenses.getPersonalLicensePack_License(), licenses.getPersonalLicenseRequisites_User()}));
        routes.define("validFrom", (EAttributeRoute)new SimpleAttributeRoute(licenses.getValidityPeriodClosed_From(), new EReference[]{licenses.getPersonalFeatureGrant_Valid()}));
        routes.define("validUntil", (EAttributeRoute)new SimpleAttributeRoute(licenses.getValidityPeriodClosed_Until(), new EReference[]{licenses.getPersonalFeatureGrant_Valid()}));
        routes.ignore("requestIdentifier", licenses.getPersonalLicensePack());
        this.defineLicensePlanRouts((MigrationRoutes)routes, licenses);
        return routes;
    }

    private void defineLicensePlanRouts(MigrationRoutes routes, LicensesPackage licenses) {
        routes.define("featureIdentifier", (EAttributeRoute)new SimpleAttributeRoute(licenses.getFeatureRef_Identifier(), new EReference[]{licenses.getLicensePlanFeature_Feature()}));
        routes.define("matchVersion", (EAttributeRoute)new SimpleAttributeRoute(licenses.getVersionMatch_Version(), new EReference[]{licenses.getLicensePlanFeature_Feature(), licenses.getFeatureRef_VersionMatch()}));
        routes.define("matchRule", (EAttributeRoute)new SimpleAttributeRoute(licenses.getVersionMatch_Rule(), new EReference[]{licenses.getLicensePlanFeature_Feature(), licenses.getFeatureRef_VersionMatch()}));
    }

    private void migrate033() {
        String uri = "http://www.eclipse.org/passage/lic/0.3.3";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private void migrate040() {
        String uri = "http://www.eclipse.org/passage/lic/licenses/0.4.0";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private void migrate050() {
        String uri = "http://www.eclipse.org/passage/lic/licenses/0.5.0";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private void migrate100() {
        String uri = "http://www.eclipse.org/passage/lic/licenses/1.0.0";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private void migrate110() {
        String uri = "http://www.eclipse.org/passage/lic/licenses/1.1.0";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private EClassRoutes classRoutes200() {
        LicensesPackage delegate = LicensesPackage.eINSTANCE;
        SimpleClassRoutes routes = new SimpleClassRoutes();
        routes.define("LicenseGrant", delegate.getPersonalFeatureGrant());
        routes.define("LicensePack", delegate.getPersonalLicensePack());
        routes.define("LicensePlan", delegate.getLicensePlan());
        return routes;
    }

    private void migrate200() {
        String uri = "http://www.eclipse.org/passage/lic/licenses/2.0.0";
        LicensesPackage delegate = LicensesPackage.eINSTANCE;
        EPackage.Registry.INSTANCE.computeIfAbsent((Object)uri, ns -> delegate);
    }
}

