/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.license;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.licenses.FloatingLicensePackDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.LicenseRequisitesDescriptor;
import org.eclipse.passage.lic.licenses.PersonalLicensePackDescriptor;
import org.eclipse.passage.loc.report.internal.core.license.LicensePlanReport;
import org.eclipse.passage.loc.report.internal.core.license.LicensePlanReportParameters;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.eclipse.passage.loc.yars.internal.api.FetchedData;

final class LicensePlanReportFetch
implements FetchedData<LicenseStorage, LicensePlanReport> {
    private final LicenseStorage storage;
    private final LicensePlanReportParameters parameters;

    LicensePlanReportFetch(LicenseStorage storage, LicensePlanReportParameters parameters) {
        this.storage = storage;
        this.parameters = parameters;
    }

    public List<LicensePlanReport> get() {
        return this.parameters.plans().stream().map(this::entry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<LicensePlanReport> entry(String id) {
        Optional<LicensePlanDescriptor> plan = this.storage.plan(id);
        if (!plan.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new LicensePlanReport(plan.get(), this.licenses(all -> all.personal(id), PersonalLicensePackDescriptor::getLicense, pack -> pack.getLicense().getUser().getIdentifier()), this.licenses(all -> all.floating(id), FloatingLicensePackDescriptor::getLicense, pack -> pack.getLicense().getCompany().getIdentifier()), this.parameters.explain()));
    }

    private <P> Map<String, List<P>> licenses(Function<LicenseStorage, List<? extends P>> packs, Function<P, LicenseRequisitesDescriptor> license, Function<P, String> owner) {
        return packs.apply(this.storage).stream().filter(pack -> ((LicenseRequisitesDescriptor)license.apply(pack)).getIssueDate().after(this.parameters.from())).filter(pack -> ((LicenseRequisitesDescriptor)license.apply(pack)).getIssueDate().before(this.parameters.to())).collect(Collectors.groupingBy(owner));
    }
}

