/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.version;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.version.SemanticVersion;
import org.eclipse.passage.lic.base.version.NumericalVersion;

public final class BaseSemanticVersion
implements SemanticVersion {
    private final int major;
    private final int minor;
    private final int service;
    private final Optional<String> qualifier;

    public BaseSemanticVersion(int major, int minor, int service, Optional<String> qualifier) {
        Objects.requireNonNull(qualifier, "SemanticVersion::qualifier");
        this.major = major;
        this.minor = minor;
        this.service = service;
        this.qualifier = qualifier;
    }

    public BaseSemanticVersion(int major, int minor, int service, String qualifier) {
        this(major, minor, service, Optional.ofNullable(qualifier));
    }

    public BaseSemanticVersion(int major, int minor, int service) {
        this(major, minor, service, Optional.empty());
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int service() {
        return this.service;
    }

    public boolean hasQualifier() {
        return this.qualifier.isPresent();
    }

    public String qualifier() {
        return this.qualifier.get();
    }

    public String toString() {
        String numerical = new NumericalVersion(this).get().stream().map(i -> i.toString()).collect(Collectors.joining("."));
        return String.valueOf(numerical) + (this.hasQualifier() ? String.valueOf('.') + this.qualifier() : "");
    }
}

