/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core.issue;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.passage.lic.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.loc.internal.licenses.core.issue.ClosedValidityPeriodReduction;
import org.eclipse.passage.loc.internal.licenses.core.issue.Reduction;

public final class PersonalLicenseIssuingProtection
implements Consumer<PersonalLicensePack> {
    private final String feature = "org.eclipse.passage.loc.operator.issue.personal.full";
    private final List<Reduction<PersonalFeatureGrant>> reductions = Arrays.asList(new ClosedValidityPeriodReduction<PersonalFeatureGrant>(this::validGet, this::validSet));

    @Override
    public void accept(PersonalLicensePack license) {
        if (new EquinoxPassage().canUse("org.eclipse.passage.loc.operator.issue.personal.full")) {
            return;
        }
        this.diminish(license);
    }

    private void diminish(PersonalLicensePack license) {
        license.getGrants().forEach(this::diminishGrant);
    }

    private void diminishGrant(PersonalFeatureGrant grant) {
        this.reductions.forEach(r -> r.accept(grant));
    }

    private Optional<ValidityPeriodClosed> validGet(PersonalFeatureGrant grant) {
        return Optional.of(new BaseValidityPeriodClosed(this.date(((org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed)grant.getValid()).getFrom()), this.date(((org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed)grant.getValid()).getUntil())));
    }

    private void validSet(PersonalFeatureGrant grant, ValidityPeriodClosed period) {
        ((org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed)grant.getValid()).setFrom(Date.from(period.from().toInstant()));
        ((org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed)grant.getValid()).setUntil(Date.from(period.to().toInstant()));
    }

    private ZonedDateTime date(Date date) {
        return ZonedDateTime.from(date.toInstant().atZone(ZoneId.systemDefault()));
    }
}

