/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.observatory;

import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.passage.lic.internal.api.observatory.Limited;
import org.eclipse.passage.lic.internal.api.observatory.Observatory;
import org.eclipse.passage.lic.internal.base.observatory.CheckSchedule;
import org.eclipse.passage.lic.internal.base.observatory.Guard;
import org.eclipse.passage.lic.internal.base.observatory.Pool;

public final class BaseObservatory<T extends Limited>
implements Observatory<T> {
    private final Pool<T> pool = new Pool();
    private final Guard<T> guard;

    public BaseObservatory(CheckSchedule schedule, Consumer<Set<T>> farewell) {
        this.guard = new Guard<T>(schedule, this.pool, farewell);
    }

    public void open() {
        new Thread(this.guard).start();
    }

    public void watch(T limited) {
        this.pool.watch(limited);
    }

    public void forget(T limited) {
        this.pool.forget(limited);
    }
}

