/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.restrictions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.api.restrictions.PermissionsExaminationService;
import org.eclipse.passage.lic.internal.api.restrictions.Restriction;
import org.eclipse.passage.lic.internal.base.diagnostic.code.InsufficientLicenseCoverage;
import org.eclipse.passage.lic.internal.base.restrictions.BaseExaminationCertificate;
import org.eclipse.passage.lic.internal.base.restrictions.BaseRestriction;

public final class BasePermissionsExaminationService
implements PermissionsExaminationService {
    private final StringServiceId id = new StringServiceId("base-permissions-examination-service");

    public StringServiceId id() {
        return this.id;
    }

    public ExaminationCertificate examine(Collection<Requirement> requirements, Collection<Permission> permissions, LicensedProduct product) {
        Objects.requireNonNull(requirements);
        Objects.requireNonNull(permissions);
        Objects.requireNonNull(product);
        HashMap<Requirement, Permission> active = new HashMap<Requirement, Permission>();
        Collection restrictions = requirements.stream().collect(Collectors.groupingBy(Requirement::feature)).entrySet().stream().map(e -> this.examineFeature((Collection)e.getValue(), permissions, product, active)).flatMap(Collection::stream).collect(Collectors.toList());
        return new BaseExaminationCertificate(active, restrictions);
    }

    private Collection<Restriction> examineFeature(Collection<Requirement> requirements, Collection<Permission> permissions, LicensedProduct product, Map<Requirement, Permission> active) {
        return requirements.stream().filter(requirement -> !this.covered((Requirement)requirement, permissions, active)).map(requirement -> this.restriction((Requirement)requirement, product)).collect(Collectors.toList());
    }

    private boolean covered(Requirement requirement, Collection<Permission> permissions, Map<Requirement, Permission> active) {
        return permissions.stream().filter(permission -> this.sameFeature(requirement, (Permission)permission)).filter(permission -> this.versionMatches(requirement, (Permission)permission)).peek(permission -> {
            Permission permission2 = active.put(requirement, (Permission)permission);
        }).findAny().isPresent();
    }

    private boolean sameFeature(Requirement requirement, Permission permission) {
        return requirement.feature().identifier().equals(permission.condition().feature());
    }

    private boolean versionMatches(Requirement requirement, Permission permission) {
        return permission.condition().versionMatch().rule().match(requirement.feature().version(), permission.condition().versionMatch().version());
    }

    private Restriction restriction(Requirement requirement, LicensedProduct product) {
        return new BaseRestriction(product, requirement, new InsufficientLicenseCoverage());
    }
}

