/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanFeatureDescriptor;
import org.eclipse.passage.lic.licenses.model.api.LicenseGrant;
import org.eclipse.passage.lic.licenses.model.api.LicensePack;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.LicenseGrantFromRequest;

final class PersonalLicensePackFromRequest
implements Supplier<LicensePack> {
    private final PersonalLicenseRequest request;
    private final LicenseRegistry licenses;

    PersonalLicensePackFromRequest(PersonalLicenseRequest request, LicenseRegistry licesnses) {
        this.request = request;
        this.licenses = licesnses;
    }

    @Override
    public LicensePack get() {
        LicensesFactory licenseFactory = LicensesFactory.eINSTANCE;
        LicensePack pack = licenseFactory.createLicensePack();
        pack.setRequestIdentifier(this.request.identifier());
        pack.setUserIdentifier(this.request.user());
        pack.setUserFullName(this.request.userFullName());
        pack.setProductIdentifier(this.request.productIdentifier());
        pack.setProductVersion(this.request.productVersion());
        String planIdentifier = this.request.plan();
        pack.setPlanIdentifier(planIdentifier);
        LicensePlanDescriptor plan = this.licenses.getLicensePlan(planIdentifier);
        if (plan == null) {
            return pack;
        }
        Iterable features = plan.getLicensePlanFeatures();
        EList grants = pack.getLicenseGrants();
        for (LicensePlanFeatureDescriptor planFeature : features) {
            LicenseGrant grant = new LicenseGrantFromRequest(planFeature, this.request).get();
            grants.add((Object)grant);
        }
        return pack;
    }
}

