/*******************************************************************************
 * Copyright (c) 2020 ArSysOp
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     ArSysOp - initial API and implementation
 *******************************************************************************/
package org.eclipse.passage.lic.floating.model.impl;

import java.util.Date;
import java.util.Objects;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.passage.lic.floating.model.api.GrantAcqisition;
import org.eclipse.passage.lic.floating.model.meta.FloatingPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Grant
 * Acqisition</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.passage.lic.floating.model.impl.GrantAcqisitionImpl#getIdentifier
 * <em>Identifier</em>}</li>
 * <li>{@link org.eclipse.passage.lic.floating.model.impl.GrantAcqisitionImpl#getFeature
 * <em>Feature</em>}</li>
 * <li>{@link org.eclipse.passage.lic.floating.model.impl.GrantAcqisitionImpl#getGrant
 * <em>Grant</em>}</li>
 * <li>{@link org.eclipse.passage.lic.floating.model.impl.GrantAcqisitionImpl#getUser
 * <em>User</em>}</li>
 * <li>{@link org.eclipse.passage.lic.floating.model.impl.GrantAcqisitionImpl#getCreated
 * <em>Created</em>}</li>
 * </ul>
 *
 * @generated
 */
public class GrantAcqisitionImpl extends MinimalEObjectImpl.Container implements GrantAcqisition {
	/**
	 * The default value of the '{@link #getIdentifier() <em>Identifier</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected static final String IDENTIFIER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	private String identifier = IDENTIFIER_EDEFAULT;

	/**
	 * The default value of the '{@link #getFeature() <em>Feature</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getFeature()
	 * @generated
	 * @ordered
	 */
	protected static final String FEATURE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFeature() <em>Feature</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getFeature()
	 * @generated
	 * @ordered
	 */
	private String feature = FEATURE_EDEFAULT;

	/**
	 * The default value of the '{@link #getGrant() <em>Grant</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getGrant()
	 * @generated
	 * @ordered
	 */
	protected static final String GRANT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getGrant() <em>Grant</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getGrant()
	 * @generated
	 * @ordered
	 */
	private String grant = GRANT_EDEFAULT;

	/**
	 * The default value of the '{@link #getUser() <em>User</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getUser()
	 * @generated
	 * @ordered
	 */
	protected static final String USER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUser() <em>User</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getUser()
	 * @generated
	 * @ordered
	 */
	private String user = USER_EDEFAULT;

	/**
	 * The default value of the '{@link #getCreated() <em>Created</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getCreated()
	 * @generated
	 * @ordered
	 */
	protected static final Date CREATED_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCreated() <em>Created</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getCreated()
	 * @generated
	 * @ordered
	 */
	private Date created = CREATED_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected GrantAcqisitionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return FloatingPackage.eINSTANCE.getGrantAcqisition();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setIdentifier(String newIdentifier) {
		String oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FloatingPackage.GRANT_ACQISITION__IDENTIFIER,
					oldIdentifier, identifier));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getFeature() {
		return feature;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setFeature(String newFeature) {
		String oldFeature = feature;
		feature = newFeature;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FloatingPackage.GRANT_ACQISITION__FEATURE, oldFeature,
					feature));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getGrant() {
		return grant;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setGrant(String newGrant) {
		String oldGrant = grant;
		grant = newGrant;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FloatingPackage.GRANT_ACQISITION__GRANT, oldGrant,
					grant));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getUser() {
		return user;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setUser(String newUser) {
		String oldUser = user;
		user = newUser;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FloatingPackage.GRANT_ACQISITION__USER, oldUser,
					user));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Date getCreated() {
		return created;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setCreated(Date newCreated) {
		Date oldCreated = created;
		created = newCreated;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, FloatingPackage.GRANT_ACQISITION__CREATED, oldCreated,
					created));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case FloatingPackage.GRANT_ACQISITION__IDENTIFIER:
			return getIdentifier();
		case FloatingPackage.GRANT_ACQISITION__FEATURE:
			return getFeature();
		case FloatingPackage.GRANT_ACQISITION__GRANT:
			return getGrant();
		case FloatingPackage.GRANT_ACQISITION__USER:
			return getUser();
		case FloatingPackage.GRANT_ACQISITION__CREATED:
			return getCreated();
		default:
			return super.eGet(featureID, resolve, coreType);
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case FloatingPackage.GRANT_ACQISITION__IDENTIFIER:
			setIdentifier((String) newValue);
			return;
		case FloatingPackage.GRANT_ACQISITION__FEATURE:
			setFeature((String) newValue);
			return;
		case FloatingPackage.GRANT_ACQISITION__GRANT:
			setGrant((String) newValue);
			return;
		case FloatingPackage.GRANT_ACQISITION__USER:
			setUser((String) newValue);
			return;
		case FloatingPackage.GRANT_ACQISITION__CREATED:
			setCreated((Date) newValue);
			return;
		default:
			super.eSet(featureID, newValue);
			return;
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case FloatingPackage.GRANT_ACQISITION__IDENTIFIER:
			setIdentifier(IDENTIFIER_EDEFAULT);
			return;
		case FloatingPackage.GRANT_ACQISITION__FEATURE:
			setFeature(FEATURE_EDEFAULT);
			return;
		case FloatingPackage.GRANT_ACQISITION__GRANT:
			setGrant(GRANT_EDEFAULT);
			return;
		case FloatingPackage.GRANT_ACQISITION__USER:
			setUser(USER_EDEFAULT);
			return;
		case FloatingPackage.GRANT_ACQISITION__CREATED:
			setCreated(CREATED_EDEFAULT);
			return;
		default:
			super.eUnset(featureID);
			return;
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case FloatingPackage.GRANT_ACQISITION__IDENTIFIER:
			return !Objects.equals(IDENTIFIER_EDEFAULT, identifier);
		case FloatingPackage.GRANT_ACQISITION__FEATURE:
			return !Objects.equals(FEATURE_EDEFAULT, feature);
		case FloatingPackage.GRANT_ACQISITION__GRANT:
			return !Objects.equals(GRANT_EDEFAULT, grant);
		case FloatingPackage.GRANT_ACQISITION__USER:
			return !Objects.equals(USER_EDEFAULT, user);
		case FloatingPackage.GRANT_ACQISITION__CREATED:
			return !Objects.equals(CREATED_EDEFAULT, created);
		default:
			return super.eIsSet(featureID);
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}
		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (identifier: "); //$NON-NLS-1$
		result.append(identifier);
		result.append(", feature: "); //$NON-NLS-1$
		result.append(feature);
		result.append(", grant: "); //$NON-NLS-1$
		result.append(grant);
		result.append(", user: "); //$NON-NLS-1$
		result.append(user);
		result.append(", created: "); //$NON-NLS-1$
		result.append(created);
		result.append(')');
		return result.toString();
	}

} // GrantAcqisitionImpl
