/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.io.StreamCodec;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanFeatureDescriptor;
import org.eclipse.passage.lic.licenses.model.api.LicenseGrant;
import org.eclipse.passage.lic.licenses.model.api.LicensePack;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.loc.internal.api.CodecSupplier;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.api.LicensingRequest;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.api.OperatorProductService;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component
public class LicenseOperatorServiceImpl
implements OperatorLicenseService {
    private EnvironmentInfo environmentInfo;
    private EventAdmin eventAdmin;
    private ProductRegistry productRegistry;
    private UserRegistry userRegistry;
    private LicenseRegistry licenseRegistry;
    private OperatorProductService operatorProductService;

    @Reference
    public void bindEnvironmentInfo(EnvironmentInfo environment) {
        this.environmentInfo = environment;
    }

    public void unbindEnvironmentInfo(EnvironmentInfo environment) {
        if (Objects.equals(this.environmentInfo, environment)) {
            this.environmentInfo = null;
        }
    }

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.eventAdmin = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        if (Objects.equals(this.eventAdmin, admin)) {
            this.eventAdmin = null;
        }
    }

    @Reference
    public void bindProductRegistry(ProductRegistry registry) {
        this.productRegistry = registry;
    }

    public void unbindProductRegistry(ProductRegistry registry) {
        if (Objects.equals(this.productRegistry, registry)) {
            this.productRegistry = null;
        }
    }

    @Reference
    public void bindLicenseRegistry(LicenseRegistry registry) {
        this.licenseRegistry = registry;
    }

    public void unbindLicenseRegistry(LicenseRegistry registry) {
        if (Objects.equals(this.licenseRegistry, registry)) {
            this.licenseRegistry = null;
        }
    }

    @Reference
    public void bindUserRegistry(UserRegistry registry) {
        this.userRegistry = registry;
    }

    public void unbindUserRegistry(UserRegistry registry) {
        if (Objects.equals(this.userRegistry, registry)) {
            this.userRegistry = null;
        }
    }

    @Reference
    public void bindProductOperatorService(OperatorProductService productService) {
        this.operatorProductService = productService;
    }

    public void unbindProductOperatorService(OperatorProductService productService) {
        if (Objects.equals(this.operatorProductService, productService)) {
            this.operatorProductService = null;
        }
    }

    /*
     * Exception decompiling
     */
    public ServiceInvocationResult<IssuedLicense> issueLicensePack(LicensingRequest request, LicensePackDescriptor template) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<StreamCodec> codec(LicensedProduct product) {
        return new CodecSupplier(product).get();
    }

    public LicensePack createLicensePack(LicensingRequest request) {
        LicensesFactory licenseFactory = LicensesFactory.eINSTANCE;
        LicensePack licensePack = licenseFactory.createLicensePack();
        if (request == null) {
            return licensePack;
        }
        licensePack.setRequestIdentifier(request.getIdentifier());
        licensePack.setUserIdentifier(request.getUserIdentifier());
        licensePack.setUserFullName(request.getUserFullName());
        licensePack.setProductIdentifier(request.getProductIdentifier());
        licensePack.setProductVersion(request.getProductVersion());
        String planIdentifier = request.getPlanIdentifier();
        licensePack.setPlanIdentifier(planIdentifier);
        LicensePlanDescriptor licensePlan = this.licenseRegistry.getLicensePlan(planIdentifier);
        if (licensePlan == null) {
            return licensePack;
        }
        Iterable features = licensePlan.getLicensePlanFeatures();
        Date from = request.getValidFrom();
        Date until = request.getValidUntil();
        String conditionType = request.getConditionType();
        String expression = request.getConditionExpression();
        EList grants = licensePack.getLicenseGrants();
        for (LicensePlanFeatureDescriptor planFeature : features) {
            LicenseGrant grant = this.createLicenseGrant(planFeature, from, until, conditionType, expression);
            grants.add((Object)grant);
        }
        return licensePack;
    }

    private LicenseGrant createLicenseGrant(LicensePlanFeatureDescriptor planFeature, Date from, Date until, String conditionType, String expression) {
        LicensesFactory licenseFactory = LicensesFactory.eINSTANCE;
        LicenseGrant grant = licenseFactory.createLicenseGrant();
        grant.setFeatureIdentifier(planFeature.getFeatureIdentifier());
        grant.setMatchVersion(planFeature.getMatchVersion());
        grant.setMatchRule(planFeature.getMatchRule());
        grant.setCapacity(1);
        grant.setConditionExpression(expression);
        grant.setConditionType(conditionType);
        grant.setValidFrom(from);
        grant.setValidUntil(until);
        return grant;
    }
}

