/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.repository.artifact.spi;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;

public class ArtifactDescriptor
implements IArtifactDescriptor,
IMemberProvider {
    public static final String MEMBER_ARTIFACT_KEY = "artifactKey";
    public static final String MEMBER_PROCESSING_STEPS = "processingSteps";
    public static final String MEMBER_PROPERTIES = "properties";
    public static final String MEMBER_REPOSITORY = "repository";
    private static final IProcessingStepDescriptor[] EMPTY_STEPS = new ProcessingStepDescriptor[0];
    protected IArtifactKey key;
    protected IProcessingStepDescriptor[] processingSteps = EMPTY_STEPS;
    protected Map<String, String> properties = new OrderedProperties();
    private transient IArtifactRepository repository;

    public ArtifactDescriptor(IArtifactDescriptor base) {
        this.key = base.getArtifactKey();
        this.setProcessingSteps(base.getProcessingSteps());
        this.properties.putAll(base.getProperties());
        this.repository = base.getRepository();
    }

    public ArtifactDescriptor(IArtifactKey key) {
        this.key = key;
    }

    @Override
    public IArtifactKey getArtifactKey() {
        return this.key;
    }

    @Override
    public String getProperty(String propertyKey) {
        return this.properties.get(propertyKey);
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public void addProperties(Map<String, String> additionalProperties) {
        this.properties.putAll(additionalProperties);
    }

    @Override
    public Map<String, String> getProperties() {
        return OrderedProperties.unmodifiableProperties(this.properties);
    }

    @Override
    public IProcessingStepDescriptor[] getProcessingSteps() {
        return this.processingSteps;
    }

    public void setProcessingSteps(IProcessingStepDescriptor[] value) {
        this.processingSteps = value == null || value.length == 0 ? EMPTY_STEPS : value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ArtifactDescriptor other = (ArtifactDescriptor)obj;
        return Objects.equals(this.key, other.getArtifactKey()) && Arrays.equals(this.processingSteps, other.getProcessingSteps()) && Objects.equals(this.getProperty("format"), other.getProperty("format"));
    }

    public int hashCode() {
        return Objects.hash(this.key, Arrays.asList(this.processingSteps), this.getProperty("format"));
    }

    @Override
    public IArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IArtifactRepository value) {
        this.repository = value;
    }

    public String toString() {
        String format = this.getProperty("format");
        if (format == null) {
            return "canonical: " + this.key.toString();
        }
        return format + ": " + this.key.toString();
    }

    public Object getMember(String memberName) {
        return switch (memberName) {
            case MEMBER_ARTIFACT_KEY -> this.key;
            case MEMBER_PROPERTIES -> this.properties;
            case MEMBER_PROCESSING_STEPS -> this.processingSteps;
            case MEMBER_REPOSITORY -> this.repository;
            default -> throw new IllegalArgumentException("No such member: " + memberName);
        };
    }
}

