/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.dnd.NavigatorPluginDropAction;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorDnDService;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.PluginTransfer;

public final class CommonDropAdapter
extends PluginDropAdapter {
    private static final Transfer[] SUPPORTED_DROP_TRANSFERS = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
    private final INavigatorContentService contentService;
    private final INavigatorDnDService dndService;

    public CommonDropAdapter(INavigatorContentService aContentService, StructuredViewer aStructuredViewer) {
        super(aStructuredViewer);
        this.contentService = aContentService;
        this.dndService = this.contentService.getDnDService();
        this.setFeedbackEnabled(false);
    }

    public Transfer[] getSupportedDropTransfers() {
        return SUPPORTED_DROP_TRANSFERS;
    }

    public void dragEnter(DropTargetEvent event) {
        TransferData dataType;
        if (event.detail == 0) {
            return;
        }
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.dragEnter: " + String.valueOf(event));
        }
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            dataType = transferDataArray[n2];
            if (LocalSelectionTransfer.getTransfer().isSupportedType(dataType)) {
                event.currentDataType = dataType;
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.dragEnter: local selection: " + String.valueOf(event.currentDataType));
                }
                super.dragEnter(event);
                return;
            }
            ++n2;
        }
        transferDataArray = event.dataTypes;
        n = event.dataTypes.length;
        n2 = 0;
        while (n2 < n) {
            dataType = transferDataArray[n2];
            if (FileTransfer.getInstance().isSupportedType(dataType)) {
                event.currentDataType = dataType;
                event.detail = 1;
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.dragEnter: file: " + String.valueOf(event.currentDataType));
                }
                super.dragEnter(event);
                return;
            }
            ++n2;
        }
        transferDataArray = event.dataTypes;
        n = event.dataTypes.length;
        n2 = 0;
        while (n2 < n) {
            dataType = transferDataArray[n2];
            if (PluginTransfer.getInstance().isSupportedType(dataType)) {
                event.currentDataType = dataType;
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.dragEnter: plugin: " + String.valueOf(event.currentDataType));
                }
                super.dragEnter(event);
                return;
            }
            ++n2;
        }
        event.detail = 0;
    }

    public void dragLeave(DropTargetEvent event) {
        super.dragLeave(event);
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            event.data = NavigatorPluginDropAction.createTransferData(this.contentService);
        }
    }

    public boolean performDrop(Object data) {
        final DropTargetEvent event = this.getCurrentEvent();
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.drop (begin): " + String.valueOf(event));
        }
        final Object target = this.getCurrentTarget() != null ? this.getCurrentTarget() : this.getViewer().getInput();
        this.validateDrop(target, this.getCurrentOperation(), event.currentDataType);
        if (PluginTransfer.getInstance().isSupportedType(event.currentDataType)) {
            super.drop(event);
            return true;
        }
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.drop target: " + String.valueOf(target) + " op: " + this.getCurrentOperation());
        }
        CommonDropAdapterAssistant[] assistants = this.dndService.findCommonDropAdapterAssistants(target, this.getCurrentTransfer());
        final boolean[] retValue = new boolean[1];
        CommonDropAdapterAssistant[] commonDropAdapterAssistantArray = assistants;
        int n = assistants.length;
        int n2 = 0;
        while (n2 < n) {
            final CommonDropAdapterAssistant localAssistant = commonDropAdapterAssistantArray[n2];
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                @Override
                public void run() throws Exception {
                    localAssistant.setCurrentEvent(event);
                    IStatus valid = localAssistant.validateDrop(target, CommonDropAdapter.this.getCurrentOperation(), CommonDropAdapter.this.getCurrentTransfer());
                    if (valid != null && valid.isOK()) {
                        if (Policy.DEBUG_DND) {
                            System.out.println("CommonDropAdapter.drop assistant selected: " + String.valueOf(localAssistant) + " op: " + event.detail);
                        }
                        localAssistant.handleDrop(CommonDropAdapter.this, event, target);
                        retValue[0] = true;
                    }
                }
            });
            if (retValue[0]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean validateDrop(Object aDropTarget, final int theDropOperation, final TransferData theTransferData) {
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.validateDrop (begin) operation: " + theDropOperation + " target: " + String.valueOf(aDropTarget));
        }
        boolean result = false;
        final IStatus[] valid = new IStatus[1];
        if (super.validateDrop(aDropTarget, theDropOperation, theTransferData)) {
            result = true;
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDropAdapter.validateDrop valid for plugin transfer");
            }
        } else {
            CommonDropAdapterAssistant[] assistants;
            Object target;
            Object object = target = aDropTarget != null ? aDropTarget : this.getViewer().getInput();
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDropAdapter.validateDrop target: " + String.valueOf(target));
                System.out.println("CommonDropAdapter.validateDrop local selection: " + String.valueOf(LocalSelectionTransfer.getTransfer().getSelection()));
            }
            CommonDropAdapterAssistant[] commonDropAdapterAssistantArray = assistants = this.dndService.findCommonDropAdapterAssistants(target, theTransferData);
            int n = assistants.length;
            int n2 = 0;
            while (n2 < n) {
                final CommonDropAdapterAssistant assistantLocal = commonDropAdapterAssistantArray[n2];
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.validateDrop checking assistant: \"" + String.valueOf(assistantLocal));
                }
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    @Override
                    public void run() throws Exception {
                        assistantLocal.setCurrentEvent(CommonDropAdapter.this.getCurrentEvent());
                        valid[0] = assistantLocal.validateDrop(target, theDropOperation, theTransferData);
                    }
                });
                if (valid[0] != null && valid[0].isOK()) {
                    result = true;
                    if (!Policy.DEBUG_DND) break;
                    System.out.println("CommonDropAdapter.validateDrop VALID");
                    break;
                }
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.validateDrop NOT valid: " + (String)(valid[0] != null ? valid[0].getSeverity() + ": " + valid[0].getMessage() : ""));
                }
                ++n2;
            }
        }
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.validateDrop (returning " + (valid[0] != null ? valid[0].getSeverity() + ": " + valid[0].getMessage() : "" + result) + ")");
        }
        this.setScrollExpandEnabled(true);
        return result;
    }

    public Rectangle getBounds(Item item) {
        return super.getBounds(item);
    }

    public int getCurrentLocation() {
        return super.getCurrentLocation();
    }

    public int getCurrentOperation() {
        return super.getCurrentOperation();
    }

    public void overrideOperation(int operation) {
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.overrideOperation: " + operation);
        }
        super.overrideOperation(operation);
    }

    public Object getCurrentTarget() {
        return super.getCurrentTarget();
    }

    public TransferData getCurrentTransfer() {
        return super.getCurrentTransfer();
    }
}

