/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal;

import java.util.Locale;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.localization.LocaleProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class StructuredTextActivator
implements BundleActivator {
    private ServiceTracker<FrameworkLog, FrameworkLog> logTracker = null;
    private BundleContext bundleContext;
    private static StructuredTextActivator instance;

    public StructuredTextActivator() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        this.bundleContext = null;
    }

    public static StructuredTextActivator getInstance() {
        return instance;
    }

    public static String getProperty(String key) {
        if (instance != null) {
            return StructuredTextActivator.instance.bundleContext.getProperty(key);
        }
        return System.getProperty(key);
    }

    public Locale getDefaultLocale() {
        ServiceReference[] references = null;
        try {
            references = this.bundleContext.getAllServiceReferences(null, LocaleProvider.class.getName());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (references == null || references.length < 1) {
            return Locale.getDefault();
        }
        Object service = this.bundleContext.getService(references[0]);
        LocaleProvider localeProvider = (LocaleProvider)service;
        if (localeProvider != null) {
            Locale currentLocale = localeProvider.getLocale();
            this.bundleContext.ungetService(references[0]);
            if (currentLocale != null) {
                return currentLocale;
            }
        }
        return Locale.getDefault();
    }

    private FrameworkLog getFrameworkLog() {
        if (this.logTracker == null) {
            this.logTracker = new ServiceTracker(this.bundleContext, FrameworkLog.class, null);
            this.logTracker.open();
        }
        return (FrameworkLog)this.logTracker.getService();
    }

    public static void logError(String message, Exception e) {
        FrameworkLog frameworkLog;
        if (instance != null && (frameworkLog = instance.getFrameworkLog()) != null) {
            frameworkLog.log(new FrameworkLogEntry("org.eclipse.equinox.bidi", 4, 1, message, 0, (Throwable)e, null));
            return;
        }
        System.err.println(message);
        if (e != null) {
            e.printStackTrace();
        }
    }
}

