/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.extractor.lib.JREData;
import org.eclipse.oomph.internal.jreinfo.JREInfoPlugin;
import org.eclipse.oomph.jreinfo.InfoManager;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.JREInfo;
import org.eclipse.oomph.jreinfo.Messages;
import org.eclipse.oomph.jreinfo.OSType;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public final class JREManager {
    public static final OSType OS_TYPE = JREManager.determineOSType();
    public static final int BITNESS = JREManager.determineBitness();
    public static final boolean BITNESS_CHANGEABLE = BITNESS == 64 && OS.INSTANCE.is32BitAvailable();
    public static final String JAVA_EXECUTABLE = OS_TYPE == OSType.Win ? "java.exe" : "java";
    public static final String JAVA_COMPILER = OS_TYPE == OSType.Win ? "javac.exe" : "javac";
    public static final JREManager INSTANCE = new JREManager();
    private static final String PROP_DEFAULT_JRE = "oomph.default.jres";
    private final List<String> javaHomes = new ArrayList<String>();
    private final List<JRE.Descriptor> descriptors = new ArrayList<JRE.Descriptor>();
    private String systemJavaHome;

    private JREManager() {
        try {
            this.loadJavaHomes();
            for (File defaultJavaHome : this.getDefaultJavaHomes()) {
                this.addExtraJavaHomes(defaultJavaHome.toString(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            JREInfoPlugin.INSTANCE.log(ex);
        }
    }

    private Set<File> getDefaultJavaHomes() {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        String defaultJREs = PropertiesUtil.getProperty((String)PROP_DEFAULT_JRE);
        if (defaultJREs != null) {
            try {
                String[] stringArray = defaultJREs.split(File.pathSeparator);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String defaultJRE = stringArray[n2];
                    result.add(new File(defaultJRE).getCanonicalFile());
                    ++n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private void addExtraJavaHomes(List<String> extraJavaHomes, File folder, boolean root, Set<JRE> result, IProgressMonitor monitor) {
        JREInfoPlugin.checkCancelation((IProgressMonitor)monitor);
        String path = folder.getAbsolutePath();
        File[] childFolders = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        try {
            try {
                File canonicalFolder;
                JRE info;
                File executable;
                int children = childFolders == null ? 0 : childFolders.length;
                monitor.beginTask(root ? NLS.bind((String)Messages.JREManager_Seraching_task, (Object)path) : "", 1 + children);
                monitor.subTask(path);
                if (!this.javaHomes.contains(path) && !extraJavaHomes.contains(path) && (executable = new File(folder, "bin/" + JAVA_EXECUTABLE)).isFile() && (info = InfoManager.INSTANCE.getInfo(canonicalFolder = folder.getCanonicalFile())) != null && info.isValid()) {
                    extraJavaHomes.add(path);
                    result.add(new JRE(folder, info));
                }
                monitor.worked(1);
                int i = 0;
                while (i < children) {
                    this.addExtraJavaHomes(extraJavaHomes, childFolders[i], false, result, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                    ++i;
                }
            }
            catch (OperationCanceledException ex) {
                throw ex;
            }
            catch (Exception exception) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public synchronized Set<JRE> addExtraJavaHomes(String rootFolder, IProgressMonitor monitor) {
        HashSet<JRE> result = new HashSet<JRE>();
        File folder = new File(rootFolder);
        if (folder.isDirectory()) {
            List<String> extraJavaHomes = JREManager.loadExtraJavaHomes();
            this.addExtraJavaHomes(extraJavaHomes, folder, true, result, monitor);
            if (!result.isEmpty()) {
                JREManager.saveExtraJavaHomes(extraJavaHomes);
            }
        }
        return result;
    }

    public synchronized void removeExtraJavaHomes(String ... javaHomes) {
        List<String> extraJavaHomes = JREManager.loadExtraJavaHomes();
        if (extraJavaHomes.removeAll(Arrays.asList(javaHomes))) {
            JREManager.saveExtraJavaHomes(extraJavaHomes);
        }
    }

    public synchronized void refresh(boolean refreshInfos) {
        if (refreshInfos) {
            InfoManager.INSTANCE.refresh();
        }
        this.loadJavaHomes();
    }

    public String getDefaultJRE(int bitness, String javaVersion) {
        File defaultsFile;
        Map properties;
        String javaHome;
        Set<File> defaultJavaHomes = this.getDefaultJavaHomes();
        if (!defaultJavaHomes.isEmpty()) {
            JREFilter jreFilter = new JREFilter(javaVersion, (Integer)bitness, null);
            Map<File, JRE> jres = this.getJREs(jreFilter);
            for (File defaultJavaHome : defaultJavaHomes) {
                if (!jres.containsKey(defaultJavaHome)) continue;
                return defaultJavaHome.toString();
            }
        }
        if ((javaHome = (String)(properties = PropertiesUtil.getProperties((File)(defaultsFile = JREManager.getDefaultsFile()))).get(JREManager.getDefaultsKey(bitness, javaVersion))) == null) {
            javaHome = (String)properties.get(JREManager.getDefaultsKey(bitness, null));
        }
        return javaHome;
    }

    public synchronized void setDefaultJRE(int bitness, String javaVersion, String javaHome) {
        File defaultsFile = JREManager.getDefaultsFile();
        Map properties = PropertiesUtil.getProperties((File)defaultsFile);
        String oldVersionSpecificJavaHome = properties.put(JREManager.getDefaultsKey(bitness, javaVersion), javaHome);
        String oldJavaHome = properties.put(JREManager.getDefaultsKey(bitness, null), javaHome);
        if (!javaHome.equals(oldVersionSpecificJavaHome) || !javaHome.equals(oldJavaHome)) {
            try {
                PropertiesUtil.saveProperties((File)defaultsFile, (Map)properties, (boolean)true);
            }
            catch (Exception ex) {
                JREInfoPlugin.INSTANCE.log(ex);
            }
        }
    }

    public synchronized void setJREs(Collection<JRE.Descriptor> jreDescriptors) {
        this.descriptors.clear();
        this.descriptors.addAll(jreDescriptors);
    }

    public Map<File, JRE> getJREs() {
        return this.getJREs(null);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized JRE getSystemJRE() {
        if (this.systemJavaHome == null) {
            if (OS.INSTANCE.isWin()) {
                folders = new ArrayList<String>();
                path = System.getenv("PATH");
                var6_6 = path.split(File.pathSeparator);
                var5_7 = var6_6.length;
                var4_9 = 0;
                while (var4_9 < var5_7) {
                    folder = var6_6[var4_9];
                    this.systemJavaHome = "";
                    if (!StringUtil.isEmpty((String)folder)) {
                        if (folder.indexOf(47) == -1) {
                            folders.add(folder);
                        } else {
                            v0 = isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;
                            if (isDebug) {
                                folders.clear();
                            }
                        }
                    }
                    ++var4_9;
                }
                size = folders.size();
                if (size > 0) {
                    folders.remove(size - 1);
                }
                for (String folder : folders) {
                    jreData = InfoManager.testJRE(new File(folder, JREManager.JAVA_EXECUTABLE).toString());
                    if (jreData == null) continue;
                    this.systemJavaHome = jreData.getJavaHome();
                    break;
                }
            } else if (OS.INSTANCE.isLinux()) {
                try {
                    javaExecuable = new File("/usr/bin/java").getCanonicalFile();
                    jreData = InfoManager.testJRE(javaExecuable.toString());
                    if (jreData == null) ** GOTO lbl40
                    this.systemJavaHome = jreData.getJavaHome();
                }
                catch (IOException var1_3) {
                    // empty catch block
                }
            }
        }
        if (!StringUtil.isEmpty((String)this.systemJavaHome)) {
            return this.getJREs().get(new File(this.systemJavaHome));
        }
        return null;
    }

    public Map<File, JRE> getJREs(JREFilter filter) {
        Set<File> folders = this.getJavaHomes();
        List<JRE> jres = JREManager.getJREs(filter, folders);
        LinkedHashMap<File, JRE> result = new LinkedHashMap<File, JRE>();
        for (JRE jre : jres) {
            result.put(jre.getJavaHome(), jre);
        }
        return result;
    }

    public JRE[] getJREs(JREFilter filter, boolean extra) {
        Set<File> folders = JREManager.toFile(extra ? JREManager.loadExtraJavaHomes() : this.javaHomes);
        List<JRE> jres = JREManager.getJREs(filter, folders);
        return jres.toArray(new JRE[jres.size()]);
    }

    public JRE[] getAllJREs(JREFilter filter) {
        ArrayList<JRE> jres = new ArrayList<JRE>();
        for (JRE.Descriptor descriptor : this.descriptors) {
            JRE jre = new JRE(descriptor);
            if (!jre.isMatch(filter)) continue;
            jres.add(jre);
        }
        Collections.sort(jres);
        jres.addAll(0, this.getJREs(filter).values());
        return jres.toArray(new JRE[jres.size()]);
    }

    private synchronized Set<File> getJavaHomes() {
        HashSet<File> all = new HashSet<File>();
        all.addAll(JREManager.toFile(this.javaHomes));
        all.addAll(JREManager.toFile(JREManager.loadExtraJavaHomes()));
        return all;
    }

    private void loadJavaHomes() {
        this.javaHomes.clear();
        File installerLocation = JREManager.getInstallerLocation();
        JREInfo info = JREInfo.getAll();
        while (info != null) {
            if (installerLocation == null || !this.isAncestor(installerLocation, new File(info.javaHome))) {
                this.javaHomes.add(info.javaHome);
            }
            info = info.next;
        }
    }

    private boolean isAncestor(File parent, File child) {
        File file = IOUtil.getCanonicalFile((File)child);
        while (file != null) {
            if (parent.equals(file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    private static List<String> loadExtraJavaHomes() {
        if (JREManager.getCacheFile().isFile()) {
            try {
                return IOUtil.readLines((File)JREManager.getCacheFile(), (String)"UTF-8");
            }
            catch (Exception ex) {
                JREInfoPlugin.INSTANCE.log(ex);
            }
        }
        return new ArrayList<String>();
    }

    private static void saveExtraJavaHomes(List<String> paths) {
        try {
            IOUtil.writeLines((File)JREManager.getCacheFile(), (String)"UTF-8", paths);
        }
        catch (Exception ex) {
            JREInfoPlugin.INSTANCE.log(ex);
        }
    }

    private static File getCacheFile() {
        return new File(JREInfoPlugin.INSTANCE.getUserLocation().append("extra.txt").toOSString());
    }

    private static File getDefaultsFile() {
        return new File(JREInfoPlugin.INSTANCE.getUserLocation().append("defaults.properties").toOSString());
    }

    private static String getDefaultsKey(int bitness, String javaVersion) {
        return String.valueOf(Integer.toString(bitness)) + "/" + JREManager.sanitizeKey(javaVersion);
    }

    private static String sanitizeKey(String javaVersion) {
        if (javaVersion == null) {
            return "*";
        }
        return javaVersion.replace(' ', '_').replace('/', '_').replace('\\', '_').replace('=', '_');
    }

    private static List<JRE> getJREs(JREFilter filter, Collection<File> javaHomes) {
        ArrayList<JRE> list = new ArrayList<JRE>();
        for (File javaHome : javaHomes) {
            try {
                File canonicalJavaHome = javaHome.getCanonicalFile();
                JRE info = InfoManager.INSTANCE.getInfo(canonicalJavaHome);
                if (info == null || !info.isValid() || filter != null && !info.isMatch(filter)) continue;
                list.add(new JRE(javaHome, info));
            }
            catch (IOException ex) {
                JREInfoPlugin.INSTANCE.log((IStatus)new Status(2, JREInfoPlugin.INSTANCE.getSymbolicName(), NLS.bind((String)Messages.JREManager_Problem_message, (Object)javaHome), (Throwable)ex));
            }
        }
        Collections.sort(list);
        return list;
    }

    private static Set<File> toFile(Collection<String> paths) {
        HashSet<File> result = new HashSet<File>();
        for (String javaHome : paths) {
            result.add(new File(javaHome));
        }
        return result;
    }

    private static OSType determineOSType() {
        try {
            String os = Platform.getOS();
            if ("win32".equals(os)) {
                System.loadLibrary("jreinfo.dll");
                return OSType.Win;
            }
            if ("macosx".equals(os)) {
                return OSType.Mac;
            }
            if ("linux".equals(os)) {
                return OSType.Linux;
            }
        }
        catch (RuntimeException ex) {
            JREInfoPlugin.INSTANCE.log(ex);
        }
        return OSType.Unsupported;
    }

    private static int determineBitness() {
        try {
            return JREData.determineBitness();
        }
        catch (RuntimeException ex) {
            JREInfoPlugin.INSTANCE.log(ex);
            return 32;
        }
    }

    private static File getInstallerLocation() {
        try {
            URI result;
            Location location;
            String productID = PropertiesUtil.getProductID();
            if ("org.eclipse.oomph.setup.installer.product".equals(productID) && (location = Platform.getInstallLocation()) != null && (result = URI.createURI((String)FileLocator.resolve((URL)location.getURL()).toString())).isFile()) {
                if (!result.hasTrailingPathSeparator()) {
                    result = result.appendSegment("");
                }
                return IOUtil.getCanonicalFile((File)new File(result.toFileString()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

