/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.tests;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.jdt.JDTFactory;
import org.eclipse.oomph.setup.jdt.JRELibrary;
import org.eclipse.oomph.setup.jdt.JRETask;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JRETaskTest {
    private static final String RT_LIB_PATH = "lib/rt.jar";
    private static final Path EXT_ANNOTATIONS_PATH = new Path("/Configuration/annotations");
    private static final String JRE_NAME = "Test JRE for JavaSE-1.8";
    private JRETask jreTask;
    private SetupTaskContext setupTaskContext;

    @Before
    public void setUp() throws Exception {
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        SetupPrompter.Default prompter = new SetupPrompter.Default(true);
        Trigger trigger = null;
        SetupContext setupContext = SetupContext.create();
        Stream stream = null;
        this.setupTaskContext = new SetupTaskPerformer((URIConverter)uriConverter, (SetupPrompter)prompter, trigger, setupContext, stream);
        this.jreTask = JDTFactory.eINSTANCE.createJRETask();
        this.jreTask.setName(JRE_NAME);
        this.jreTask.setLocation(System.getProperty("java.home"));
        this.jreTask.setVMInstallType("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        this.jreTask.setVersion("JavaSE-1.8");
        JRELibrary jreLibrary = JDTFactory.eINSTANCE.createJRELibrary();
        jreLibrary.setLibraryPath(RT_LIB_PATH);
        jreLibrary.setExternalAnnotationsPath(EXT_ANNOTATIONS_PATH.toString());
        this.jreTask.getJRELibraries().add((Object)jreLibrary);
    }

    @After
    public void tearDown() throws Exception {
        this.setupTaskContext = null;
        this.jreTask = null;
    }

    @Test
    public void testPerform() throws Exception {
        this.checkIsNeeded(true);
        this.jreTask.perform(this.setupTaskContext);
        this.checkExternalAnnotationsPath();
        this.checkIsNeeded(false);
    }

    private void checkIsNeeded(boolean isNeeded) throws Exception {
        Assert.assertEquals((String)"JRETask.isNeeded() returned the wrong value;", (Object)isNeeded, (Object)this.jreTask.isNeeded(this.setupTaskContext));
    }

    private void checkExternalAnnotationsPath() {
        boolean foundVM = false;
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
            if (vmInstallType.getId().equals("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType")) {
                IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
                int n3 = iVMInstallArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVMInstall vmInstall = iVMInstallArray[n4];
                    if (vmInstall.getName().equals(JRE_NAME)) {
                        foundVM = true;
                        LibraryLocation[] libraryLocations = vmInstall.getLibraryLocations();
                        Assert.assertNotNull((String)"VM Install 'Test JRE for JavaSE-1.8' library configuration not applied", (Object)libraryLocations);
                        boolean foundLibrary = false;
                        IPath libraryPath = new Path(System.getProperty("java.home")).append(RT_LIB_PATH);
                        LibraryLocation[] libraryLocationArray = libraryLocations;
                        int n5 = libraryLocations.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            LibraryLocation libraryLocation = libraryLocationArray[n6];
                            if (libraryPath.equals((Object)libraryLocation.getSystemLibraryPath())) {
                                foundLibrary = true;
                                try {
                                    Assert.assertEquals((String)"External annotations path incorrect;", (Object)EXT_ANNOTATIONS_PATH, (Object)libraryLocation.getExternalAnnotationsPath());
                                }
                                catch (NoSuchMethodError noSuchMethodError) {}
                            }
                            ++n6;
                        }
                        if (!foundLibrary) {
                            Assert.fail((String)"Library 'lib/rt.jar' not found in VM Install 'Test JRE for JavaSE-1.8'");
                        }
                    }
                    ++n4;
                }
                break;
            }
            ++n2;
        }
        if (!foundVM) {
            Assert.fail((String)"VM Install 'Test JRE for JavaSE-1.8' not found");
        }
    }
}

