/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl.controller;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.types.AlertMode;
import org.eclipse.om2m.hue.api.types.HueException;
import org.eclipse.om2m.hue.api.types.LightEffect;
import org.eclipse.om2m.hue.api.types.LightState;
import org.eclipse.om2m.hue.api.types.UnknownHueGatewayException;
import org.eclipse.om2m.hue.impl.controller.HueConstants;
import org.eclipse.om2m.hue.impl.controller.Utils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class PHDevice
implements HueConstants {
    private static Log Logger = LogFactory.getLog(PHDevice.class);
    protected String IP;
    protected String userName;
    protected String id;
    protected String name;

    protected PHDevice(String IP, String usr, String id, String name) {
        this.IP = IP;
        this.userName = usr;
        this.id = id;
        this.name = name;
    }

    protected JSONObject setStateObject(LightState s) throws HueException, UnknownHueGatewayException {
        JSONObject obj = new JSONObject();
        if (s.getSat() != -1) {
            obj.put((Object)"sat", (Object)new Integer(s.getSat()));
        }
        if (s.getBri() != -1) {
            obj.put((Object)"bri", (Object)new Integer(s.getBri()));
        }
        if (s.getHue() != -1) {
            obj.put((Object)"hue", (Object)new Integer(s.getHue()));
        }
        obj.put((Object)"alert", (Object)AlertMode.getAlertMode((int)s.getAlert()));
        obj.put((Object)"effect", (Object)LightEffect.getLightEffect((int)s.getEffect()));
        obj.put((Object)"on", (Object)new Boolean(s.isOn()));
        return obj;
    }

    protected LightState getState(String resp, String param) {
        try {
            JSONObject responseObj = (JSONObject)new JSONParser().parse(resp);
            JSONObject state = (JSONObject)responseObj.get((Object)param);
            LightState s = new LightState();
            s.setOn(((Boolean)state.get((Object)"on")).booleanValue());
            s.setBri(Integer.parseInt(state.get((Object)"bri").toString()));
            s.setSat(Integer.parseInt(state.get((Object)"sat").toString()));
            s.setHue(Integer.parseInt(state.get((Object)"hue").toString()));
            s.setAlert(AlertMode.getAlertMode((String)((String)state.get((Object)"alert"))));
            s.setEffect(LightEffect.getLightEffect((String)((String)state.get((Object)"effect"))));
            return s;
        }
        catch (ParseException e) {
            Logger.warn((Object)"", (Throwable)e);
            return null;
        }
    }

    public String getIP() {
        return this.IP;
    }

    public void setIP(String iP) {
        this.IP = iP;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected final String sendGetRequest(String req) throws HueException, UnknownHueGatewayException {
        return Utils.sendGetRequest(String.valueOf(this.IP) + "/api/" + this.userName, req);
    }

    protected final String sendPutRequest(String req, String val) throws HueException, UnknownHueGatewayException {
        return Utils.sendPutRequest(String.valueOf(this.IP) + "/api/" + this.userName, req, val);
    }
}

