/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.HueBridgeDevice;
import org.eclipse.om2m.hue.api.HueLightDevice;
import org.eclipse.om2m.hue.impl.HueBridgeDeviceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HueBridgeDiscovery {
    private static Log Logger = LogFactory.getLog(HueBridgeDiscovery.class);
    private BundleContext context;
    private Map<String, HueBridgeDevice> hueBridges;
    private Map<String, ServiceRegistration<?>> hueBridgeServices;
    private Map<String, Timer> hueBridgeLightsTimer;
    private Map<String, Map<String, ServiceRegistration<?>>> registeredHueLights;
    private List<String> downloadedDescriptions;
    private String userId = null;
    private Timer hueLightsTimer = null;

    public HueBridgeDiscovery(BundleContext context) {
        this.context = context;
        this.hueBridges = new HashMap<String, HueBridgeDevice>();
        this.hueBridgeServices = new HashMap();
        this.hueBridgeLightsTimer = new HashMap<String, Timer>();
        this.registeredHueLights = new HashMap();
        this.downloadedDescriptions = new ArrayList<String>();
    }

    public void processNewHueBridge(String location) throws IOException {
        if (location.endsWith("description.xml") && !this.downloadedDescriptions.contains(location)) {
            this.processHueBridge(location, null);
            this.downloadedDescriptions.add(location);
        }
    }

    public String processHueBridge(String location) throws IOException {
        boolean hueBridgeFound = false;
        StringBuffer xmlDescription = new StringBuffer();
        BufferedReader in = null;
        try {
            String line;
            URL url = new URL(location);
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = in.readLine()) != null) {
                xmlDescription.append(line);
                hueBridgeFound |= line.toLowerCase().indexOf("<modelname>philips hue bridge") >= 0;
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (Exception exception) {}
        if (!hueBridgeFound) {
            Logger.warn((Object)"No Hue bridge found");
            return null;
        }
        Logger.info((Object)("Hue bridge found: " + location + " with userId: " + this.userId));
        HueBridgeDeviceImpl hueBridge = new HueBridgeDeviceImpl(location, xmlDescription.toString(), Optional.of(this.userId));
        if (hueBridge.isBridgeConnected()) {
            this.registerBridge(hueBridge);
        } else {
            Logger.warn((Object)"Cannot register Hue bridge: driver is not connected to the bridge");
        }
        return hueBridge.getUserName();
    }

    public String processHueBridge(String location, String id) throws IOException {
        try {
            Logger.info((Object)("ProcessHueBridge with userId: " + this.userId));
            this.userId = id == null ? "" : id;
            return this.processHueBridge(location);
        }
        catch (Throwable e) {
            Logger.warn((Object)"", e);
            throw new IOException(e);
        }
    }

    public void registerBridge(HueBridgeDevice bridge) {
        String bridgeUDN = bridge.getUDN();
        if (this.hueBridges.containsKey(bridgeUDN)) {
            return;
        }
        this.hueBridges.put(bridgeUDN, bridge);
        ServiceRegistration rg = this.context.registerService(HueBridgeDevice.class.getName(), (Object)bridge, bridge.getProperties());
        this.hueBridgeServices.put(bridgeUDN, rg);
        this.registeredHueLights.put(bridgeUDN, new HashMap());
        if (this.hueBridgeLightsTimer.containsKey(bridgeUDN)) {
            return;
        }
        this.hueLightsTimer = new Timer();
        this.hueBridgeLightsTimer.put(bridgeUDN, this.hueLightsTimer);
        this.hueLightsTimer.scheduleAtFixedRate((TimerTask)new HueLightsTimerTask(this, bridge, this.registeredHueLights.get(bridgeUDN)){

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block10: {
                    try {
                        lights = this.taskBridge.getLights();
                        if (this.taskLights.size() > 0) {
                            idsToRemove = new ArrayList<String>();
                            for (Map.Entry<K, V> entry : this.taskLights.entrySet()) {
                                id = (String)entry.getKey();
                                lightFound = false;
                                for (HueLightDevice light : lights) {
                                    if (!light.getId().equals(id)) continue;
                                    lightFound = true;
                                    break;
                                }
                                if (lightFound) continue;
                                ((ServiceRegistration)entry.getValue()).unregister();
                                idsToRemove.add(id);
                            }
                            for (Object id : idsToRemove) {
                                this.taskLights.remove(id);
                            }
                        }
                        for (HueLightDevice light : lights) {
                            if (this.taskLights.containsKey(light.getId())) continue;
                            reg = HueBridgeDiscovery.access$0(this).registerService(HueLightDevice.class.getName(), (Object)light, light.getProperties());
                            this.taskLights.put(light.getId(), reg);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        HueBridgeDiscovery.access$1().warn((Object)"Looking for Hue Lights IOException : ", (Throwable)e);
                        bridgeUDN = this.taskBridge.getUDN();
                        ** for (sr : this.taskLights.values())
                    }
lbl-1000:
                    // 1 sources

                    {
                        sr.unregister();
                        continue;
                    }
lbl34:
                    // 1 sources

                    this.taskLights.clear();
                    HueBridgeDiscovery.access$2(this).remove(bridgeUDN);
                    try {
                        HueBridgeDiscovery.access$3(this).remove(((HueBridgeDeviceImpl)this.taskBridge).getLocation());
                    }
                    catch (Exception v0) {}
                    ((ServiceRegistration)HueBridgeDiscovery.access$4(this).get(bridgeUDN)).unregister();
                    HueBridgeDiscovery.access$4(this).remove(bridgeUDN);
                    HueBridgeDiscovery.access$5(this).remove(bridgeUDN);
                    ((Timer)HueBridgeDiscovery.access$6(this).get(bridgeUDN)).cancel();
                    HueBridgeDiscovery.access$6(this).remove(bridgeUDN);
                }
            }
        }, 0L, 10000L);
    }

    public void clearDescriptions() {
        this.downloadedDescriptions.clear();
    }

    public void stopBackgroundProcesses() {
        if (this.hueLightsTimer != null) {
            this.hueLightsTimer.cancel();
        }
    }

    static /* synthetic */ BundleContext access$0(HueBridgeDiscovery hueBridgeDiscovery) {
        return hueBridgeDiscovery.context;
    }

    static /* synthetic */ Log access$1() {
        return Logger;
    }

    static /* synthetic */ Map access$2(HueBridgeDiscovery hueBridgeDiscovery) {
        return hueBridgeDiscovery.registeredHueLights;
    }

    static /* synthetic */ List access$3(HueBridgeDiscovery hueBridgeDiscovery) {
        return hueBridgeDiscovery.downloadedDescriptions;
    }

    static /* synthetic */ Map access$4(HueBridgeDiscovery hueBridgeDiscovery) {
        return hueBridgeDiscovery.hueBridgeServices;
    }

    static /* synthetic */ Map access$5(HueBridgeDiscovery hueBridgeDiscovery) {
        return hueBridgeDiscovery.hueBridges;
    }

    static /* synthetic */ Map access$6(HueBridgeDiscovery hueBridgeDiscovery) {
        return hueBridgeDiscovery.hueBridgeLightsTimer;
    }

    abstract class HueLightsTimerTask
    extends TimerTask {
        protected HueBridgeDevice taskBridge = null;
        protected Map<String, ServiceRegistration<?>> taskLights = null;

        public HueLightsTimerTask(HueBridgeDevice bridge, Map<String, ServiceRegistration<?>> lights) {
            this.taskBridge = bridge;
            this.taskLights = lights;
        }
    }
}

