/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.netatmo.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.home.driver.Logger;
import org.eclipse.om2m.sdt.home.netatmo.impl.Discovery;
import org.eclipse.om2m.sdt.home.netatmo.model.Event;
import org.eclipse.om2m.sdt.home.netatmo.model.Home;
import org.eclipse.om2m.sdt.home.netatmo.model.HomeListener;
import org.eclipse.om2m.sdt.home.netatmo.model.Person;
import org.eclipse.om2m.sdt.home.netatmo.model.WeatherStation;
import org.eclipse.om2m.sdt.home.netatmo.model.WeatherStationModule;
import org.eclipse.om2m.sdt.home.netatmo.model.WelcomeCamera;
import org.eclipse.om2m.sdt.home.netatmo.sdt.SDTWeatherStation;
import org.eclipse.om2m.sdt.home.netatmo.sdt.SDTWelcomeCameraDevice;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.LogService;

@Component(configurationPid="netatmo.sdt.driver", configurationPolicy=ConfigurationPolicy.REQUIRE, enabled=true, immediate=true, name="netatmo.sdt.driver")
public class Activator
implements HomeListener {
    public static final Domain NETATMO_DOMAIN = new Domain("Netatmo_Domain");
    public static final String PROTOCOL = "Netatmo";
    public static Logger logger = new Logger("Netatmo");
    private static int detectionThreshold;
    private static final String SERVICE_PID = "netatmo.sdt.driver";
    private Discovery discovery;
    private Map<String, WelcomeCamera> welcomeCameras;
    private Map<String, SDTWelcomeCameraDevice> sdtCameras = new HashMap<String, SDTWelcomeCameraDevice>();
    private Map<String, SDTWeatherStation> sdtWeatherStations;
    private BundleContext bundleContext;
    private ServiceRegistration serviceRegistration;

    public Activator() {
        this.welcomeCameras = new HashMap<String, WelcomeCamera>();
        this.sdtWeatherStations = new HashMap<String, SDTWeatherStation>();
    }

    @Activate
    protected void activate(BundleContext pBundleContext, Map<String, Object> properties) {
        this.bundleContext = pBundleContext;
        this.modified(properties);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        if (this.discovery != null) {
            this.discovery.stopDiscovery();
            this.discovery.removeHomeListener(this);
            this.discovery = null;
        }
        for (SDTWelcomeCameraDevice sdtWelcomeCamera : this.sdtCameras.values()) {
            sdtWelcomeCamera.unregister();
        }
        for (SDTWeatherStation sdtWeatherStation : this.sdtWeatherStations.values()) {
            sdtWeatherStation.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCameraAddedOrUpdated(Home home, WelcomeCamera camera, boolean updated) {
        if (!updated) {
            Map<String, WelcomeCamera> map = this.welcomeCameras;
            synchronized (map) {
                this.welcomeCameras.put(camera.getId(), camera);
            }
            SDTWelcomeCameraDevice sdtWelcomeCamera = new SDTWelcomeCameraDevice(camera, detectionThreshold);
            sdtWelcomeCamera.register(this.bundleContext);
            Map<String, SDTWelcomeCameraDevice> map2 = this.sdtCameras;
            synchronized (map2) {
                this.sdtCameras.put(camera.getId(), sdtWelcomeCamera);
            }
        }
    }

    @Override
    public void notifyPersonAddedOrUpdated(Home home, Person person, boolean updated) {
        SDTWelcomeCameraDevice sdtWelcomeCamera = this.getSDTWelcomeCamera(home.getCameras().values().iterator().next().getId());
        if (sdtWelcomeCamera != null) {
            if (person.getPseudo() != null) {
                if (person.getOutOfSight().booleanValue()) {
                    logger.debug(String.valueOf(person.getPseudo()) + " out of sight. Ignore...");
                } else {
                    logger.info("InSight " + person.getPseudo());
                    sdtWelcomeCamera.notifyPerson(person.getId(), person.getPseudo(), person.getLastSeen());
                }
            }
        } else {
            logger.info("notifyPersonAddedOrUpdated(" + person.toString() + ") -SDT camera not found");
        }
    }

    @Override
    public void notifyEventsUpdated(Home home, List<Event> events) {
    }

    @Override
    public void notifyHomeAdded(Home newHome) {
    }

    @Override
    public void notifyWeatherStationAddedOrUpdated(WeatherStation ws, boolean updated) {
        logger.info("notifyWeatherStationAddedOrUpdated(ws=" + ws.getId() + ", updated=" + updated + ")");
        if (!updated) {
            SDTWeatherStation sdtWS = new SDTWeatherStation(ws);
            sdtWS.register(this.bundleContext);
            this.sdtWeatherStations.put(sdtWS.getId(), sdtWS);
            for (WeatherStationModule module : ws.getModules().values()) {
                SDTWeatherStation sdtModuleWS = new SDTWeatherStation(module);
                sdtModuleWS.register(this.bundleContext);
                this.sdtWeatherStations.put(sdtModuleWS.getId(), sdtModuleWS);
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, name="logService", unbind="unsetLogService")
    protected void setLogService(LogService pLogService) {
        logger.setLogService((Object)pLogService);
        logger.info("Netatmo - logger set");
    }

    protected void unsetLogService(LogService pLogService) {
        logger.info("Netatmo - logger unset");
        logger.unsetLogService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SDTWelcomeCameraDevice getSDTWelcomeCamera(String cameraId) {
        SDTWelcomeCameraDevice sdtWelcomeCamera = null;
        Map<String, SDTWelcomeCameraDevice> map = this.sdtCameras;
        synchronized (map) {
            sdtWelcomeCamera = this.sdtCameras.get(cameraId);
        }
        return sdtWelcomeCamera;
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        logger.info("modified(properties=" + properties + ")");
        if (!Activator.checkParameters(properties)) {
            logger.info("Missing a mandatory property --> Netatmo driver is not started");
            return;
        }
        if (this.discovery != null) {
            this.discovery.stopDiscovery();
            this.discovery.removeHomeListener(this);
            this.discovery = null;
        }
        this.discovery = new Discovery(properties);
        this.discovery.addHomeListener(this);
        this.discovery.startDiscovery();
    }

    private static boolean checkParameters(Map properties) {
        logger.info("checkParameters");
        if (properties == null) {
            logger.info("No properties to configure SDT Netatmo Driver --> the driver is not started !");
            return false;
        }
        logger.info("checkParameter(properties.length=" + properties.size() + ")");
        ArrayList<String> missing = new ArrayList<String>();
        if (properties.get("client.id") == null) {
            missing.add("client.id");
        }
        if (properties.get("client.secret") == null) {
            missing.add("client.secret");
        }
        if (properties.get("username") == null) {
            missing.add("username");
        }
        if (properties.get("password") == null) {
            missing.add("password");
        }
        try {
            detectionThreshold = Integer.parseInt(properties.get("camera.detection.threshold").toString());
        }
        catch (Exception exception) {
            detectionThreshold = -1;
        }
        if (missing.isEmpty()) {
            return true;
        }
        logger.info(missing + " parameter(s) missing");
        return false;
    }
}

