/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.driver;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.driver.Logger;
import org.eclipse.om2m.sdt.home.driver.Utils;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class PersistedDevice
implements ManagedService {
    private GenericDevice device;
    private ServiceRegistration<?> registration;
    private Logger logger;

    PersistedDevice(GenericDevice device) {
        this.device = device;
        String protocol = device.getProtocol();
        this.logger = new Logger(protocol == null ? "Driver" : protocol);
    }

    void setRegistration(ServiceRegistration<?> registration) {
        this.registration = registration;
    }

    public void updated(Dictionary props) throws ConfigurationException {
        if (props != null && this.updateDevice(props)) {
            try {
                this.registration.setProperties(props);
            }
            catch (Exception e) {
                throw new ConfigurationException(null, null, (Throwable)e);
            }
        }
    }

    public boolean updateDevice(Dictionary<?, ?> props) {
        boolean modified = false;
        Enumeration<?> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = (String)props.get(key);
            Property old = this.device.getProperty(key, false);
            if (old == null) {
                this.logger.info("Unknown property (not SDT): " + key + "/" + val);
                continue;
            }
            if (Utils.equals(old.getValue(), val)) {
                this.logger.info("Unchanged property: " + key + "/" + val);
                continue;
            }
            old.setValue(val);
            modified = true;
            this.logger.info("Set persisted property: " + key + "/" + val);
        }
        return modified;
    }
}

