/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.monitoring.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.FilterUsage;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.FilterCriteria;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.URIList;
import org.eclipse.om2m.core.service.CseService;

public class ResourceDiscovery {
    public static CseService cseService;
    private static Log LOGGER;
    private static final String SEARCH_STRING_DISCOVERY_PARAMETER = "searchString";
    private static final String RESOURCE_ID_SEARCH_STRING = "ResourceID/";
    private static final String RESOURCE_TYPE_APPLICATION_SEARCH_STRING = "ResourceType/Application";

    static {
        LOGGER = LogFactory.getLog(ResourceDiscovery.class);
    }

    public static void initCseService(CseService pCseService) {
        cseService = pCseService;
    }

    public static String validateUserCredentials(String name, String password) {
        LOGGER.info((Object)("validateUserCredentials " + name + "/" + password));
        RequestPrimitive request = new RequestPrimitive();
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setFrom(String.valueOf(name) + ":" + password);
        request.setFilterCriteria(new FilterCriteria());
        request.setOperation(Operation.RETRIEVE);
        request.getFilterCriteria().setFilterUsage(FilterUsage.DISCOVERY_CRITERIA);
        request.getFilterCriteria().getLabels().add("ResourceID/SDT_Home_Monitoring_Application");
        request.getFilterCriteria().getLabels().add(RESOURCE_TYPE_APPLICATION_SEARCH_STRING);
        request.setTo("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        ResponsePrimitive response = cseService.doRequest(request);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            LOGGER.info((Object)"KO");
            return null;
        }
        URIList uriList = (URIList)response.getContent();
        LOGGER.info((Object)("OK " + uriList));
        return uriList == null || uriList.getListOfUri().isEmpty() ? null : (String)uriList.getListOfUri().get(0);
    }
}

