/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.entities;

import ee.jakarta.tck.nosql.entities.Drink;
import jakarta.nosql.Column;
import jakarta.nosql.DiscriminatorValue;
import jakarta.nosql.Entity;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.datafaker.Faker;

@DiscriminatorValue(value="BEER")
@Entity
public class Beer
extends Drink {
    @Column
    private String brand;
    @Column
    private String style;

    public String getBrand() {
        return this.brand;
    }

    public String getStyle() {
        return this.style;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String toString() {
        return "Beer{brand='" + this.brand + "', style='" + this.style + "', id='" + this.id + "', name='" + this.name + "', alcoholPercentage=" + this.alcoholPercentage + "}";
    }

    public static Beer of(Faker faker) {
        net.datafaker.providers.food.Beer fakeBeer = faker.beer();
        Beer beer = new Beer();
        beer.id = UUID.randomUUID().toString();
        beer.brand = fakeBeer.brand();
        beer.name = fakeBeer.name();
        beer.style = fakeBeer.style();
        beer.alcoholPercentage = ThreadLocalRandom.current().nextDouble(10.0, 100.0);
        return beer;
    }
}

