/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.util.PlatformHelper;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileOutputStreamProvider
implements IOutputStreamProvider {
    protected String defaultFileName;
    protected String[] defaultFilterNames;
    protected String[] defaultFilterExtensions;
    protected String currentFileName;
    protected int extFilterIndex = -1;

    public FileOutputStreamProvider(String defaultFileName, String[] defaultFilterNames, String[] defaultFilterExtensions) {
        this.defaultFileName = defaultFileName;
        this.defaultFilterNames = defaultFilterNames;
        this.defaultFilterExtensions = defaultFilterExtensions;
    }

    @Override
    public OutputStream getOutputStream(Shell shell) {
        if (shell == null) {
            throw new IllegalArgumentException("Shell can not be null");
        }
        if (!PlatformHelper.isRAP()) {
            shell.getDisplay().syncExec(() -> {
                String relativeFileName;
                String filterPath;
                FileDialog dialog = new FileDialog(shell, 8192);
                int lastIndexOfFileSeparator = this.defaultFileName.lastIndexOf(File.separator);
                if (lastIndexOfFileSeparator >= 0) {
                    filterPath = this.defaultFileName.substring(0, lastIndexOfFileSeparator);
                    relativeFileName = this.defaultFileName.substring(lastIndexOfFileSeparator + 1);
                } else {
                    filterPath = "/";
                    relativeFileName = this.defaultFileName;
                }
                PlatformHelper.callSetter((Object)dialog, "setFilterPath", String.class, filterPath);
                PlatformHelper.callSetter((Object)dialog, "setOverwrite", Boolean.TYPE, true);
                PlatformHelper.callSetter((Object)dialog, "setFileName", String.class, relativeFileName);
                PlatformHelper.callSetter((Object)dialog, "setFilterNames", String[].class, (Object)this.defaultFilterNames);
                dialog.setFilterExtensions(this.defaultFilterExtensions);
                this.currentFileName = dialog.open();
                this.extFilterIndex = -1;
                Object filterIndex = PlatformHelper.callGetter(dialog, "getFilterIndex");
                if (filterIndex != null) {
                    this.extFilterIndex = (Integer)filterIndex;
                }
            });
        } else {
            try {
                Path tempDirectory = Files.createTempDirectory("nattable_export_", new FileAttribute[0]);
                Path exportFile = tempDirectory.resolve(this.defaultFileName);
                this.currentFileName = exportFile.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write the export to a temporary directory", e);
            }
        }
        if (this.currentFileName == null) {
            return null;
        }
        try {
            return new PrintStream(this.currentFileName);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("FileOutputStreamProvider.errorMessage", this.currentFileName), e);
        }
    }

    @Override
    public File getResult() {
        return this.currentFileName != null ? new File(this.currentFileName) : null;
    }

    public int getExtensionFilterIndex() {
        return this.extFilterIndex;
    }
}

