/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.NatTableConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;

public final class CellStyleUtil {
    private CellStyleUtil() {
    }

    public static IStyle getCellStyle(ILayerCell cell, IConfigRegistry configRegistry) {
        return new CellStyleProxy(configRegistry, cell.getDisplayMode(), (List<String>)cell.getConfigLabels());
    }

    public static int getHorizontalAlignmentPadding(IStyle cellStyle, Rectangle rectangle, int contentWidth) {
        HorizontalAlignmentEnum horizontalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT);
        return CellStyleUtil.getHorizontalAlignmentPadding(horizontalAlignment, rectangle, contentWidth);
    }

    public static int getHorizontalAlignmentPadding(HorizontalAlignmentEnum horizontalAlignment, Rectangle rectangle, int contentWidth) {
        if (horizontalAlignment == null) {
            horizontalAlignment = HorizontalAlignmentEnum.CENTER;
        }
        int padding = 0;
        if (horizontalAlignment == HorizontalAlignmentEnum.CENTER) {
            padding = (rectangle.width - contentWidth) / 2;
        } else if (horizontalAlignment == HorizontalAlignmentEnum.RIGHT) {
            padding = rectangle.width - contentWidth;
        }
        if (padding < 0) {
            padding = 0;
        }
        return padding;
    }

    public static int getVerticalAlignmentPadding(IStyle cellStyle, Rectangle rectangle, int contentHeight) {
        VerticalAlignmentEnum verticalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT);
        return CellStyleUtil.getVerticalAlignmentPadding(verticalAlignment, rectangle, contentHeight);
    }

    public static int getVerticalAlignmentPadding(VerticalAlignmentEnum verticalAlignment, Rectangle rectangle, int contentHeight) {
        if (verticalAlignment == null) {
            verticalAlignment = VerticalAlignmentEnum.MIDDLE;
        }
        int padding = 0;
        if (verticalAlignment == VerticalAlignmentEnum.MIDDLE) {
            padding = (rectangle.height - contentHeight) / 2;
        } else if (verticalAlignment == VerticalAlignmentEnum.BOTTOM) {
            padding = rectangle.height - contentHeight;
        }
        if (padding < 0) {
            padding = 0;
        }
        return padding;
    }

    @Deprecated
    public static List<Color> getAllBackgroundColors(ILayerCell cell, IConfigRegistry configRegistry, String displayMode) {
        return CellStyleUtil.getAllBackgroundColors(cell, configRegistry, DisplayMode.valueOf(displayMode));
    }

    public static List<Color> getAllBackgroundColors(ILayerCell cell, IConfigRegistry configRegistry, DisplayMode displayMode) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String configLabel : cell.getConfigLabels()) {
            Color color;
            IStyle cellStyle = configRegistry.getSpecificConfigAttribute(CellConfigAttributes.CELL_STYLE, displayMode, configLabel);
            if (cellStyle == null || (color = cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR)) == null) continue;
            colors.add(color);
        }
        return colors;
    }

    public static Font getFont(IStyle cellStyle, IConfigRegistry configRegistry) {
        Float scalingFactor = configRegistry != null ? configRegistry.getConfigAttribute(NatTableConfigAttributes.FONT_SCALING_FACTOR, DisplayMode.NORMAL, new String[0]) : null;
        return GUIHelper.getScaledFont(cellStyle.getAttributeValue(CellStyleAttributes.FONT), scalingFactor != null ? scalingFactor.floatValue() : 1.0f);
    }
}

