/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.scaling;

import java.util.function.Consumer;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.scaling.ResetScalingAction;
import org.eclipse.nebula.widgets.nattable.ui.scaling.ScalingMouseWheelListener;
import org.eclipse.nebula.widgets.nattable.ui.scaling.ZoomInScalingAction;
import org.eclipse.nebula.widgets.nattable.ui.scaling.ZoomOutScalingAction;
import org.eclipse.swt.SWT;

public class ScalingUiBindingConfiguration
extends AbstractUiBindingConfiguration {
    private Consumer<IConfigRegistry> updater;

    public ScalingUiBindingConfiguration(NatTable natTable) {
        this(natTable, null);
    }

    public ScalingUiBindingConfiguration(NatTable natTable, Consumer<IConfigRegistry> updater) {
        if (natTable != null) {
            natTable.addMouseWheelListener(new ScalingMouseWheelListener(updater));
        }
        this.updater = updater;
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 48), new ResetScalingAction(this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 43), new ZoomInScalingAction(this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 45), new ZoomOutScalingAction(this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 0x1000030), new ResetScalingAction(this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 16777259), new ZoomInScalingAction(this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 16777261), new ZoomOutScalingAction(this.updater));
    }
}

