/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Stack;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.RunAndTrackExt;
import org.eclipse.e4.core.internal.di.Requestor;

public class ContextObjectSupplier
extends PrimaryObjectSupplier {
    protected static final String ECLIPSE_CONTEXT_NAME = IEclipseContext.class.getName();
    private final IEclipseContext context;

    public ContextObjectSupplier(IEclipseContext context, IInjector injector) {
        this.context = context;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public void get(IObjectDescriptor[] descriptors, Object[] actualArgs, IRequestor requestor, boolean initial, boolean track, boolean group) {
        String[] keys = new String[descriptors.length];
        boolean[] active = new boolean[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            String key = this.getKey(descriptors[i]);
            keys[i] = actualArgs[i] == IInjector.NOT_A_VALUE ? key : (ECLIPSE_CONTEXT_NAME.equals(key) ? ECLIPSE_CONTEXT_NAME : null);
            active[i] = descriptors[i] == null ? false : descriptors[i].hasQualifier(Active.class);
            ++i;
        }
        if (requestor != null && track) {
            if (initial) {
                ContextInjectionListener trackable = new ContextInjectionListener(this.context, actualArgs, keys, active, requestor, group);
                this.context.runAndTrack(trackable);
            } else {
                this.fillArgs(actualArgs, keys, active);
            }
        } else if (descriptors.length > 0) {
            this.pauseRecording();
            try {
                this.fillArgs(actualArgs, keys, active);
            }
            finally {
                this.resumeRecording();
            }
        }
    }

    private void fillArgs(Object[] actualArgs, String[] keys, boolean[] active) {
        int i = 0;
        while (i < keys.length) {
            if (keys[i] != null) {
                IEclipseContext targetContext;
                IEclipseContext iEclipseContext = targetContext = active[i] ? this.context.getActiveLeaf() : this.context;
                if (ECLIPSE_CONTEXT_NAME.equals(keys[i])) {
                    actualArgs[i] = targetContext;
                } else if (targetContext.containsKey(keys[i])) {
                    actualArgs[i] = targetContext.get(keys[i]);
                }
            }
            ++i;
        }
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor.hasQualifier(Named.class)) {
            Named namedAnnotation = (Named)descriptor.getQualifier(Named.class);
            return namedAnnotation.value();
        }
        Type elementType = descriptor.getDesiredType();
        return this.typeToString(elementType);
    }

    private String typeToString(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return this.typeToString(rawType);
        }
        return null;
    }

    public synchronized void pauseRecording() {
        Stack<Computation> current = EclipseContext.getCalculatedComputations();
        current.push(null);
    }

    public synchronized void resumeRecording() {
        Stack<Computation> current = EclipseContext.getCalculatedComputations();
        Computation plug = current.pop();
        if (plug != null) {
            throw new IllegalArgumentException("Internal error in nested computation processing");
        }
    }

    public static ContextObjectSupplier getObjectSupplier(IEclipseContext context, IInjector injector) {
        if (context == null) {
            return null;
        }
        ContextObjectSupplier supplier = (ContextObjectSupplier)((Object)((EclipseContext)context).internalGet((EclipseContext)context, ContextObjectSupplier.class.getName(), true));
        if (supplier != null) {
            return supplier;
        }
        ContextObjectSupplier objectSupplier = new ContextObjectSupplier(context, injector);
        context.set(ContextObjectSupplier.class, objectSupplier);
        return objectSupplier;
    }

    public WeakReference<Object> makeReference(Object object) {
        if (this.context instanceof EclipseContext) {
            return ((EclipseContext)this.context).trackedWeakReference(object);
        }
        return super.makeReference(object);
    }

    public static class ContextInjectionListener
    extends RunAndTrackExt {
        private final Object[] result;
        private final String[] keys;
        private final boolean[] active;
        private final IRequestor requestor;
        private final IEclipseContext context;

        public ContextInjectionListener(IEclipseContext context, Object[] result, String[] keys, boolean[] active, IRequestor requestor, boolean group) {
            super(group);
            this.result = result;
            this.keys = keys;
            this.active = active;
            this.requestor = requestor;
            this.context = context;
        }

        @Override
        public Reference<Object> getReference() {
            if (this.requestor instanceof Requestor) {
                return ((Requestor)this.requestor).getReference();
            }
            return super.getReference();
        }

        @Override
        public boolean update(IEclipseContext eventsContext, int eventType, Object[] extraArguments) {
            if (eventType == 0) {
                int i = 0;
                while (i < this.keys.length) {
                    if (this.keys[i] != null) {
                        IEclipseContext targetContext;
                        IEclipseContext iEclipseContext = targetContext = this.active[i] ? this.context.getActiveLeaf() : this.context;
                        if (ECLIPSE_CONTEXT_NAME.equals(this.keys[i])) {
                            this.result[i] = targetContext;
                            IEclipseContext parent = targetContext.getParent();
                            if (parent == null) {
                                targetContext.get(ECLIPSE_CONTEXT_NAME);
                            }
                        } else if (targetContext.containsKey(this.keys[i])) {
                            this.result[i] = targetContext.get(this.keys[i]);
                        }
                    }
                    ++i;
                }
                return true;
            }
            switch (eventType) {
                case 3: {
                    if (eventsContext != this.context) break;
                    ContextObjectSupplier originatingSupplier = eventsContext.getLocal(ContextObjectSupplier.class);
                    this.requestor.disposed((PrimaryObjectSupplier)originatingSupplier);
                    return false;
                }
                case 4: {
                    if (eventsContext != this.context) break;
                    ContextObjectSupplier originatingSupplier = eventsContext.getLocal(ContextObjectSupplier.class);
                    return this.requestor.uninject(extraArguments[0], (PrimaryObjectSupplier)originatingSupplier);
                }
                default: {
                    if (!this.requestor.isValid()) {
                        return false;
                    }
                    this.requestor.resolveArguments(false);
                    this.requestor.execute();
                }
            }
            return true;
        }

        @Override
        public boolean changed(IEclipseContext eventsContext) {
            return true;
        }

        public int hashCode() {
            int hashRresult = 1;
            hashRresult = 31 * hashRresult + Objects.hashCode(this.context);
            return 31 * hashRresult + Objects.hashCode(this.requestor);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextInjectionListener other = (ContextInjectionListener)obj;
            return Objects.equals(this.context, other.context) && Objects.equals(this.requestor, other.requestor);
        }

        public String toString() {
            return this.requestor.toString();
        }
    }
}

