/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree;

import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.tree.AbstractTreeRowModel;

public class GlazedListTreeRowModel<T>
extends AbstractTreeRowModel<T> {
    public GlazedListTreeRowModel(GlazedListTreeData<T> treeData) {
        super(treeData);
    }

    public boolean isCollapsed(int index) {
        if (!this.getTreeData().isValidIndex(index)) {
            return false;
        }
        return !this.getTreeData().getTreeList().isExpanded(index);
    }

    public List<Integer> collapse(int index) {
        if (this.getTreeData().isValidIndex(index)) {
            this.getTreeData().getTreeList().setExpanded(index, false);
            this.notifyListeners();
        }
        return new ArrayList<Integer>();
    }

    public List<Integer> collapseAll() {
        TreeList treeList = this.getTreeData().getTreeList();
        treeList.getReadWriteLock().writeLock().lock();
        try {
            int i = treeList.size() - 1;
            while (i >= 0) {
                if (this.hasChildren(i) && !this.isCollapsed(i)) {
                    treeList.setExpanded(i, false);
                }
                --i;
            }
        }
        finally {
            treeList.getReadWriteLock().writeLock().unlock();
        }
        this.notifyListeners();
        return new ArrayList<Integer>();
    }

    public List<Integer> expand(int index) {
        if (this.getTreeData().isValidIndex(index)) {
            this.getTreeData().getTreeList().setExpanded(index, true);
            this.notifyListeners();
        }
        return new ArrayList<Integer>();
    }

    public List<Integer> expandToLevel(int parentIndex, int level) {
        if (this.getTreeData().isValidIndex(parentIndex)) {
            this.internalExpandToLevel(parentIndex, level);
            this.notifyListeners();
        }
        return new ArrayList<Integer>();
    }

    protected void internalExpandToLevel(int parentIndex, int level) {
        if (this.getTreeData().isValidIndex(parentIndex) && this.depth(parentIndex) <= level - 1) {
            this.getTreeData().getTreeList().setExpanded(parentIndex, true);
            List directChildren = this.getDirectChildIndexes(parentIndex);
            Collections.sort(directChildren, Collections.reverseOrder());
            for (Integer child : directChildren) {
                if (!this.hasChildren(child) || this.depth(child) > level - 1) continue;
                this.internalExpandToLevel(child, level);
            }
        }
    }

    public List<Integer> expandAll() {
        this.internalExpandAll();
        this.notifyListeners();
        return new ArrayList<Integer>();
    }

    protected void internalExpandAll() {
        TreeList treeList = this.getTreeData().getTreeList();
        boolean expandPerformed = false;
        treeList.getReadWriteLock().writeLock().lock();
        try {
            int i = treeList.size() - 1;
            while (i >= 0) {
                if (this.hasChildren(i) && this.isCollapsed(i)) {
                    treeList.setExpanded(i, true);
                    expandPerformed = true;
                }
                --i;
            }
        }
        finally {
            treeList.getReadWriteLock().writeLock().unlock();
        }
        if (expandPerformed) {
            this.expandAll();
        }
    }

    public List<Integer> expandToLevel(int level) {
        this.internalExpandToLevel(level);
        this.notifyListeners();
        return new ArrayList<Integer>();
    }

    protected void internalExpandToLevel(int level) {
        TreeList treeList = this.getTreeData().getTreeList();
        boolean expandPerformed = false;
        treeList.getReadWriteLock().writeLock().lock();
        try {
            int i = treeList.size() - 1;
            while (i >= 0) {
                if (this.hasChildren(i) && this.isCollapsed(i) && treeList.getTreeNode(i).path().size() <= level) {
                    treeList.setExpanded(i, true);
                    expandPerformed = true;
                }
                --i;
            }
        }
        finally {
            treeList.getReadWriteLock().writeLock().unlock();
        }
        if (expandPerformed) {
            this.expandToLevel(level);
        }
    }

    public GlazedListTreeData<T> getTreeData() {
        return (GlazedListTreeData)super.getTreeData();
    }
}

