/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TableCellPainter
extends BackgroundPainter {
    private final ICellPainter internalPainter;
    private Color gridColor;
    private Color selectedGridColor;
    private int fixedSubCellHeight;
    private boolean calculateParentCellHeight = true;
    private boolean paintBg = true;

    public TableCellPainter() {
        this(new TextPainter());
    }

    public TableCellPainter(ICellPainter internalPainter) {
        this(internalPainter, GUIHelper.COLOR_GRAY, GUIHelper.COLOR_WHITE, 20, true);
    }

    public TableCellPainter(ICellPainter internalPainter, Color gridColor, Color selectedGridColor, int fixedSubCellHeight, boolean calculateParentCellHeight) {
        this.internalPainter = internalPainter;
        this.setGridColor(gridColor);
        this.setSelectedGridColor(selectedGridColor);
        this.setFixedSubCellHeight(fixedSubCellHeight);
        this.setCalculateParentCellHeight(calculateParentCellHeight);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Object[] cellDataArray;
        if (this.paintBg) {
            super.paintCell(cell, gc, bounds, configRegistry);
        }
        if ((cellDataArray = this.getDataAsArray(cell)) != null) {
            int subGridY = bounds.y;
            if (cellDataArray != null) {
                Color originalColor = gc.getForeground();
                int i = 0;
                while (i < cellDataArray.length) {
                    ILayerCell subCell = this.createSubLayerCell(cell, cellDataArray[i]);
                    int subCellHeight = this.getSubCellHeight(subCell, gc, configRegistry);
                    Rectangle subCellBounds = new Rectangle(bounds.x, subGridY, bounds.width, subCellHeight);
                    this.getInternalPainter().paintCell(subCell, gc, subCellBounds, configRegistry);
                    gc.setForeground(cell.getDisplayMode().equals("SELECT") ? this.getSelectedGridColor() : this.getGridColor());
                    gc.drawLine(bounds.x, subGridY += subCellHeight + 1, bounds.x + bounds.width, subGridY);
                    gc.setForeground(originalColor);
                    ++subGridY;
                    ++i;
                }
                int neededHeight = subGridY - bounds.y;
                if (this.isCalculateParentCellHeight() && neededHeight > cell.getBounds().height) {
                    ILayer layer = cell.getLayer();
                    layer.doCommand(new RowResizeCommand(layer, cell.getRowPosition(), neededHeight, true));
                }
            }
        } else {
            this.getInternalPainter().paintCell(cell, gc, bounds, configRegistry);
        }
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Object[] cellDataArray = this.getDataAsArray(cell);
        if (cellDataArray != null) {
            int width = 0;
            Object[] objectArray = cellDataArray;
            int n = cellDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object data = objectArray[n2];
                ILayerCell subCell = this.createSubLayerCell(cell, data);
                width = Math.max(width, this.getInternalPainter().getPreferredWidth(subCell, gc, configRegistry));
                ++n2;
            }
            return width;
        }
        return this.getInternalPainter().getPreferredWidth(cell, gc, configRegistry);
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Object[] cellDataArray = this.getDataAsArray(cell);
        if (cellDataArray != null) {
            int height = 0;
            Object[] objectArray = cellDataArray;
            int n = cellDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object data = objectArray[n2];
                ILayerCell subCell = this.createSubLayerCell(cell, data);
                height += this.getInternalPainter().getPreferredHeight(subCell, gc, configRegistry);
                ++n2;
            }
            return height += cellDataArray.length;
        }
        return this.getInternalPainter().getPreferredHeight(cell, gc, configRegistry);
    }

    protected Object[] getDataAsArray(ILayerCell cell) {
        Object cellData = cell.getDataValue();
        Object[] cellDataArray = null;
        if (cellData != null && cellData.getClass().isArray()) {
            cellDataArray = (Object[])cellData;
        } else if (cellData instanceof Collection) {
            Collection cellDataCollection = (Collection)cellData;
            cellDataArray = cellDataCollection.toArray();
        }
        return cellDataArray;
    }

    protected ILayerCell createSubLayerCell(ILayerCell cell, final Object dataValue) {
        LayerCell subCell = new LayerCell(cell.getLayer(), cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnPosition(), cell.getRowPosition(), 0, 0){

            @Override
            public Object getDataValue() {
                return dataValue;
            }
        };
        return subCell;
    }

    protected int getSubCellHeight(ILayerCell subCell, GC gc, IConfigRegistry configRegistry) {
        return this.fixedSubCellHeight >= 0 ? this.fixedSubCellHeight : this.getInternalPainter().getPreferredHeight(subCell, gc, configRegistry);
    }

    protected ICellPainter getInternalPainter() {
        return this.internalPainter;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Color getSelectedGridColor() {
        return this.selectedGridColor;
    }

    public void setSelectedGridColor(Color selectedGridColor) {
        this.selectedGridColor = selectedGridColor;
    }

    public int getFixedSubCellHeight() {
        return this.fixedSubCellHeight;
    }

    public void setFixedSubCellHeight(int fixedSubCellHeight) {
        this.fixedSubCellHeight = fixedSubCellHeight;
    }

    public boolean isCalculateParentCellHeight() {
        return this.calculateParentCellHeight;
    }

    public void setCalculateParentCellHeight(boolean calculateParentCellHeight) {
        this.calculateParentCellHeight = calculateParentCellHeight;
    }

    public void setPaintBg(boolean paintBg) {
        this.paintBg = paintBg;
    }
}

