/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.SpanningLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.reorder.event.RowReorderEvent;

public abstract class AbstractRowHideShowLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private Map<Integer, Integer> cachedVisibleRowIndexOrder;
    private Map<Integer, Integer> cachedVisibleRowPositionOrder;
    private Map<Integer, Integer> cachedHiddenRowIndexToPositionMap;
    private final Map<Integer, Integer> startYCache = new HashMap<Integer, Integer>();

    public AbstractRowHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof RowReorderEvent) {
            RowReorderEvent reorderEvent = (RowReorderEvent)event;
            TreeSet<Integer> fromPositions = new TreeSet<Integer>();
            for (int pos : reorderEvent.getBeforeFromRowIndexes()) {
                fromPositions.add(this.getRowPositionByIndex(pos));
            }
            List<Range> fromRanges = PositionUtil.getRanges(fromPositions);
            int pos = -1;
            if (!this.isRowIndexHidden(reorderEvent.getBeforeToRowIndex())) {
                pos = this.getRowPositionByIndex(reorderEvent.getBeforeToRowIndex());
            } else {
                int i = 1;
                while (pos < 0) {
                    int next = reorderEvent.getBeforeToRowPosition() + i;
                    pos = this.underlyingToLocalRowPosition(this.underlyingLayer, next);
                }
                reorderEvent.setBeforeToRowIndex(this.getRowIndexByPosition(pos));
            }
            reorderEvent.setConvertedBeforePositions(this, fromRanges, pos);
        }
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isVerticalStructureChanged()) {
                this.invalidateCache();
            }
        } else if (event instanceof VisualRefreshEvent) {
            this.startYCache.clear();
        }
        super.handleLayerEvent(event);
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.getCachedVisibleRowIndexes().size();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition < 0 || rowPosition >= this.getRowCount()) {
            return -1;
        }
        Integer rowIndex = this.getCachedVisibleRowPositons().get(rowPosition);
        if (rowIndex != null) {
            return rowIndex;
        }
        return -1;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        Integer position = this.getCachedVisibleRowIndexes().get(rowIndex);
        return position != null ? position : -1;
    }

    public Collection<Integer> getRowPositionsByIndexes(Collection<Integer> rowIndexes) {
        HashSet<Integer> rowPositions = new HashSet<Integer>();
        for (int rowIndex : rowIndexes) {
            rowPositions.add(this.getRowPositionByIndex(rowIndex));
        }
        return rowPositions;
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int rowIndex = this.getRowIndexByPosition(localRowPosition);
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getRowPositionByIndex(rowIndex);
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        int rowIndex = this.getUnderlyingLayer().getRowIndexByPosition(underlyingRowPosition);
        int rowPosition = this.getRowPositionByIndex(rowIndex);
        if (rowPosition >= 0) {
            return rowPosition;
        }
        Integer hiddenRowPosition = this.getCachedHiddenRowIndexToPositionMap().get(rowIndex);
        if (hiddenRowPosition != null) {
            return hiddenRowPosition;
        }
        return -1;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        ArrayList<Range> localRowPositionRanges = new ArrayList<Range>(underlyingRowPositionRanges.size());
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            int startRowPosition = this.getAdjustedUnderlyingToLocalStartPosition(sourceUnderlyingLayer, underlyingRowPositionRange.start, underlyingRowPositionRange.end);
            int endRowPosition = this.getAdjustedUnderlyingToLocalEndPosition(sourceUnderlyingLayer, underlyingRowPositionRange.end, underlyingRowPositionRange.start);
            if (startRowPosition <= -1) continue;
            localRowPositionRanges.add(new Range(startRowPosition, endRowPosition));
        }
        return localRowPositionRanges;
    }

    private int getAdjustedUnderlyingToLocalStartPosition(ILayer sourceUnderlyingLayer, int startUnderlyingPosition, int endUnderlyingPosition) {
        int localStartRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, startUnderlyingPosition);
        int offset = 0;
        while (localStartRowPosition < 0 && startUnderlyingPosition + offset < endUnderlyingPosition) {
            localStartRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, startUnderlyingPosition + offset++);
        }
        return localStartRowPosition;
    }

    private int getAdjustedUnderlyingToLocalEndPosition(ILayer sourceUnderlyingLayer, int endUnderlyingPosition, int startUnderlyingPosition) {
        int localEndRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, endUnderlyingPosition - 1);
        int offset = 0;
        while (localEndRowPosition < 0 && endUnderlyingPosition - offset > startUnderlyingPosition) {
            localEndRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, endUnderlyingPosition - offset++);
        }
        return localEndRowPosition + 1;
    }

    @Override
    public int getHeight() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        int lastRowPosition = this.getRowCount() - 1;
        return this.getStartYOfRowPosition(lastRowPosition) + this.getRowHeightByPosition(lastRowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    @Override
    public int getStartYOfRowPosition(int localRowPosition) {
        Integer cachedStartY = this.startYCache.get(localRowPosition);
        if (cachedStartY != null) {
            return cachedStartY;
        }
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingPosition = this.localToUnderlyingRowPosition(localRowPosition);
        if (underlyingPosition < 0) {
            return -1;
        }
        int underlyingStartY = underlyingLayer.getStartYOfRowPosition(underlyingPosition);
        if (underlyingStartY < 0) {
            return -1;
        }
        for (Integer hiddenIndex : this.getHiddenRowIndexes()) {
            int hiddenPosition = underlyingLayer.getRowPositionByIndex(hiddenIndex);
            if (hiddenPosition < 0 || hiddenPosition > underlyingPosition) continue;
            underlyingStartY -= underlyingLayer.getRowHeightByPosition(hiddenPosition);
        }
        this.startYCache.put(localRowPosition, underlyingStartY);
        return underlyingStartY;
    }

    public abstract boolean isRowIndexHidden(int var1);

    public abstract Collection<Integer> getHiddenRowIndexes();

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        ILayerCell cell = super.getCellByPosition(columnPosition, rowPosition);
        if (cell != null && cell.isSpannedCell()) {
            boolean rowSpanUpdated = false;
            int rowSpan = cell.getRowSpan();
            int row = 0;
            while (row < cell.getRowSpan()) {
                int rowIndex = this.getRowIndexByPosition(cell.getOriginRowPosition() + row);
                if (this.isRowIndexHidden(rowIndex)) {
                    --rowSpan;
                    rowSpanUpdated = true;
                }
                ++row;
            }
            if (rowSpanUpdated) {
                cell = new SpanningLayerCell(cell, cell.getColumnSpan(), rowSpan);
            }
        }
        return cell;
    }

    protected synchronized void invalidateCache() {
        this.cachedVisibleRowIndexOrder = null;
        this.cachedVisibleRowPositionOrder = null;
        this.cachedHiddenRowIndexToPositionMap = null;
        this.startYCache.clear();
    }

    private synchronized Map<Integer, Integer> getCachedVisibleRowIndexes() {
        if (this.cachedVisibleRowIndexOrder == null) {
            this.cacheVisibleRowIndexes();
        }
        return Collections.unmodifiableMap(this.cachedVisibleRowIndexOrder);
    }

    private synchronized Map<Integer, Integer> getCachedVisibleRowPositons() {
        if (this.cachedVisibleRowPositionOrder == null) {
            this.cacheVisibleRowIndexes();
        }
        return Collections.unmodifiableMap(this.cachedVisibleRowPositionOrder);
    }

    private synchronized Map<Integer, Integer> getCachedHiddenRowIndexToPositionMap() {
        if (this.cachedHiddenRowIndexToPositionMap == null) {
            this.cacheVisibleRowIndexes();
        }
        return Collections.unmodifiableMap(this.cachedHiddenRowIndexToPositionMap);
    }

    protected synchronized void cacheVisibleRowIndexes() {
        this.cachedVisibleRowIndexOrder = new HashMap<Integer, Integer>();
        this.cachedVisibleRowPositionOrder = new HashMap<Integer, Integer>();
        this.cachedHiddenRowIndexToPositionMap = new HashMap<Integer, Integer>();
        this.startYCache.clear();
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int rowPosition = 0;
        int parentRowPosition = 0;
        while (parentRowPosition < underlyingLayer.getRowCount()) {
            int rowIndex = underlyingLayer.getRowIndexByPosition(parentRowPosition);
            if (!this.isRowIndexHidden(rowIndex)) {
                this.cachedVisibleRowIndexOrder.put(rowIndex, rowPosition);
                this.cachedVisibleRowPositionOrder.put(rowPosition, rowIndex);
                ++rowPosition;
            } else {
                this.cachedHiddenRowIndexToPositionMap.put(rowIndex, rowPosition);
            }
            ++parentRowPosition;
        }
    }
}

