/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractTextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class VerticalTextPainter
extends AbstractTextPainter {
    private boolean rotateClockwise = false;

    public VerticalTextPainter() {
        this(false, true);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg) {
        this(wrapText, paintBg, 0);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, int spacing) {
        this(wrapText, paintBg, spacing, false);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        this(wrapText, paintBg, 0, calculate);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, boolean calculateByTextLength, boolean calculateByTextHeight) {
        this(wrapText, paintBg, 0, calculateByTextLength, calculateByTextHeight);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        super(wrapText, paintBg, spacing, calculate);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculateByTextLength, boolean calculateByTextHeight) {
        super(wrapText, paintBg, spacing, calculateByTextLength, calculateByTextHeight);
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        String value = this.convertDataType(cell, configRegistry);
        return gc.textExtent((String)value).y + this.spacing * 2 + (this.getNumberOfNewLines(value) - 1) * this.lineSpacing;
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return this.getLengthFromCache(gc, this.convertDataType(cell, configRegistry)) + this.spacing * 2 + 1;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        if (this.paintBg) {
            super.paintCell(cell, gc, rectangle, configRegistry);
        }
        if (this.paintFg) {
            Rectangle originalClipping = gc.getClipping();
            gc.setClipping(rectangle.intersection(originalClipping));
            IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
            this.setupGCFromConfig(gc, cellStyle);
            int fontHeight = gc.getFontMetrics().getHeight();
            String text = this.convertDataType(cell, configRegistry);
            text = this.getTextToDisplay(cell, gc, rectangle.height, text);
            int numberOfNewLines = this.getNumberOfNewLines(text);
            int contentHeight = fontHeight * numberOfNewLines + this.lineSpacing * (numberOfNewLines - 1) + this.spacing * 2;
            int contentToCellDiff = cell.getBounds().width - rectangle.width;
            if (contentHeight > rectangle.width && this.calculateByTextHeight) {
                ILayer layer = cell.getLayer();
                int columnPosition = cell.getColumnPosition();
                if (cell.isSpannedCell()) {
                    columnPosition = cell.getOriginColumnPosition() + cell.getColumnSpan() - 1;
                    int i = cell.getOriginColumnPosition();
                    while (i < columnPosition) {
                        contentHeight -= layer.getColumnWidthByPosition(i);
                        ++i;
                    }
                }
                layer.doCommand(new ColumnResizeCommand(layer, columnPosition, contentHeight + contentToCellDiff, true));
            }
            if (text != null && text.length() > 0) {
                Transform originalTransform = new Transform(gc.getDevice());
                gc.getTransform(originalTransform);
                Transform transform = new Transform(gc.getDevice());
                gc.getTransform(transform);
                if (numberOfNewLines == 1) {
                    int contentWidth = Math.min(this.getLengthFromCache(gc, text), rectangle.height);
                    if (!this.isRotateClockwise()) {
                        transform.rotate(-90.0f);
                        int xOffset = -rectangle.x + (-contentWidth - rectangle.y) - CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentWidth);
                        int yOffset = rectangle.x + -rectangle.y + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentHeight) + this.spacing;
                        transform.translate((float)xOffset, (float)yOffset);
                    } else {
                        transform.rotate(90.0f);
                        int horizontalPadding = CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentHeight);
                        if (horizontalPadding != 0) {
                            horizontalPadding += gc.getFontMetrics().getLeading();
                        }
                        int xOffset = rectangle.y - rectangle.x + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentWidth);
                        int yOffset = -contentHeight - rectangle.y - rectangle.x - horizontalPadding + this.spacing;
                        transform.translate((float)xOffset, (float)yOffset);
                    }
                    gc.setTransform(transform);
                    gc.drawText(text, rectangle.x, rectangle.y, 7);
                    int length = gc.textExtent((String)text).x;
                    this.paintDecoration(cellStyle, gc, rectangle.x, rectangle.y, length, fontHeight);
                } else {
                    String[] lines = text.split("\n");
                    boolean firstline = true;
                    int previousXOffset = 0;
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int xOffset;
                        String line = stringArray[n2];
                        int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.height);
                        if (!this.isRotateClockwise()) {
                            xOffset = -rectangle.x + (-lineContentWidth - rectangle.y) - CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, lineContentWidth);
                            if (firstline) {
                                transform.rotate(-90.0f);
                                int yOffset = rectangle.x + -rectangle.y + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentHeight) + this.spacing;
                                transform.translate((float)xOffset, (float)yOffset);
                                firstline = false;
                            } else {
                                transform.translate((float)(xOffset - previousXOffset), (float)(fontHeight + this.lineSpacing));
                            }
                            previousXOffset = xOffset;
                        } else {
                            xOffset = rectangle.y - rectangle.x + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, lineContentWidth);
                            if (firstline) {
                                transform.rotate(90.0f);
                                int horizontalPadding = CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentHeight);
                                if (horizontalPadding != 0) {
                                    horizontalPadding += gc.getFontMetrics().getLeading();
                                }
                                int yOffset = -contentHeight - rectangle.y - rectangle.x - horizontalPadding + this.spacing + fontHeight * (numberOfNewLines - 1) + this.lineSpacing * (numberOfNewLines - 1);
                                transform.translate((float)xOffset, (float)yOffset);
                                firstline = false;
                            } else {
                                transform.translate((float)(xOffset - previousXOffset), (float)(-fontHeight - this.lineSpacing));
                            }
                            previousXOffset = xOffset;
                        }
                        gc.setTransform(transform);
                        gc.drawText(line, rectangle.x, rectangle.y, 7);
                        int length = gc.textExtent((String)line).x;
                        this.paintDecoration(cellStyle, gc, rectangle.x, rectangle.y, length, fontHeight);
                        ++n2;
                    }
                }
                gc.setTransform(originalTransform);
                if (originalTransform != null) {
                    originalTransform.dispose();
                }
                if (transform != null) {
                    transform.dispose();
                }
            }
            gc.setClipping(originalClipping);
            this.resetGC(gc);
        }
    }

    @Override
    protected void setNewMinLength(ILayerCell cell, int contentHeight) {
        int cellLength = cell.getBounds().height;
        if (cellLength < contentHeight) {
            ILayer layer = cell.getLayer();
            int rowPosition = cell.getRowPosition();
            if (cell.isSpannedCell()) {
                rowPosition = cell.getOriginRowPosition() + cell.getRowSpan() - 1;
                int i = cell.getOriginRowPosition();
                while (i < rowPosition) {
                    contentHeight -= layer.getRowHeightByPosition(i);
                    ++i;
                }
            }
            layer.doCommand(new RowResizeCommand(layer, rowPosition, contentHeight, true));
        }
    }

    @Override
    protected int calculatePadding(ILayerCell cell, int availableLength) {
        return cell.getBounds().height - availableLength;
    }

    public boolean isRotateClockwise() {
        return this.rotateClockwise;
    }

    public void setRotateClockwise(boolean rotateClockwise) {
        this.rotateClockwise = rotateClockwise;
    }
}

