/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.util.Scheduler;

public class GlazedListsFilterRowComboBoxDataProvider<T>
extends FilterRowComboBoxDataProvider<T>
implements ListEventListener<T> {
    private static final Log LOG = LogFactory.getLog(GlazedListsFilterRowComboBoxDataProvider.class);
    private static final Scheduler SCHEDULER = new Scheduler("GlazedListsFilterRowComboBoxDataProvider");
    private AtomicBoolean changeHandlingProcessing = new AtomicBoolean(false);
    private EventList<T> baseEventList;

    public GlazedListsFilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor) {
        this(bodyLayer, baseCollection, columnAccessor, true);
    }

    public GlazedListsFilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor, boolean lazy) {
        super(bodyLayer, baseCollection, columnAccessor, lazy);
        if (baseCollection instanceof EventList) {
            this.baseEventList = (EventList)baseCollection;
            this.baseEventList.addListEventListener((ListEventListener)this);
        } else {
            LOG.error((Object)"baseCollection is not of type EventList. List changes can not be tracked.");
        }
    }

    public void listChanged(ListEvent<T> listChanges) {
        if (!this.changeHandlingProcessing.getAndSet(true)) {
            SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    ArrayList<FilterRowComboUpdateEvent> updateEvents = new ArrayList<FilterRowComboUpdateEvent>();
                    GlazedListsFilterRowComboBoxDataProvider.this.getValueCacheLock().writeLock().lock();
                    try {
                        HashMap cacheBefore = new HashMap(GlazedListsFilterRowComboBoxDataProvider.this.getValueCache());
                        GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().clear();
                        if (!GlazedListsFilterRowComboBoxDataProvider.this.lazyLoading) {
                            GlazedListsFilterRowComboBoxDataProvider.this.buildValueCache();
                        } else {
                            for (Map.Entry entry : cacheBefore.entrySet()) {
                                GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().put((Integer)entry.getKey(), GlazedListsFilterRowComboBoxDataProvider.this.collectValues((Integer)entry.getKey()));
                            }
                        }
                        for (Map.Entry entry : cacheBefore.entrySet()) {
                            updateEvents.add(GlazedListsFilterRowComboBoxDataProvider.this.buildUpdateEvent((Integer)entry.getKey(), (List)entry.getValue(), (List)GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().get(entry.getKey())));
                        }
                        GlazedListsFilterRowComboBoxDataProvider.this.changeHandlingProcessing.set(false);
                    }
                    finally {
                        GlazedListsFilterRowComboBoxDataProvider.this.getValueCacheLock().writeLock().unlock();
                    }
                    if (GlazedListsFilterRowComboBoxDataProvider.this.isUpdateEventsEnabled()) {
                        for (FilterRowComboUpdateEvent event : updateEvents) {
                            GlazedListsFilterRowComboBoxDataProvider.this.fireCacheUpdateEvent(event);
                        }
                    }
                }
            }, 100L);
        }
    }

    public void handleLayerEvent(final ILayerEvent event) {
        if (this.cachingEnabled && event instanceof CellVisualChangeEvent) {
            SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    GlazedListsFilterRowComboBoxDataProvider.this.getValueCacheLock().writeLock().lock();
                    try {
                        int column = ((CellVisualChangeEvent)event).getColumnPosition();
                        List cacheBefore = (List)GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().get(column);
                        if (!GlazedListsFilterRowComboBoxDataProvider.this.lazyLoading || cacheBefore != null) {
                            GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().put(column, GlazedListsFilterRowComboBoxDataProvider.this.collectValues(column));
                        }
                        if (GlazedListsFilterRowComboBoxDataProvider.this.isUpdateEventsEnabled()) {
                            GlazedListsFilterRowComboBoxDataProvider.this.fireCacheUpdateEvent(GlazedListsFilterRowComboBoxDataProvider.this.buildUpdateEvent(column, cacheBefore, (List)GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().get(column)));
                        }
                    }
                    finally {
                        GlazedListsFilterRowComboBoxDataProvider.this.getValueCacheLock().writeLock().unlock();
                    }
                }
            }, 0L);
        }
    }

    public void dispose() {
        super.dispose();
        SCHEDULER.shutdownNow();
    }
}

